# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SignInName(Model):
    """Contains information about a sign-in name of a local account user in an
    Azure Active Directory B2C tenant.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param type: A string value that can be used to classify user sign-in
     types in your directory, such as 'emailAddress' or 'userName'.
    :type type: str
    :param value: The sign-in used by the local account. Must be unique across
     the company/tenant. For example, 'johnc@example.com'.
    :type value: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, additional_properties=None, type=None, value=None):
        super(SignInName, self).__init__()
        self.additional_properties = additional_properties
        self.type = type
        self.value = value
