# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceSkuCosts(Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The multiplier is needed to extend the base metered cost.
    :vartype quantity: long
    :ivar extended_unit: An invariant to show the extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'quantity': {'readonly': True},
        'extended_unit': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterID', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'long'},
        'extended_unit': {'key': 'extendedUnit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceSkuCosts, self).__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None
