# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .update_resource import UpdateResource


class UserFragment(UpdateResource):
    """Profile of a lab user.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the user.
    :type identity: ~azure.mgmt.devtestlabs.models.UserIdentityFragment
    :param secret_store: The secret store of the user.
    :type secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStoreFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentityFragment'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStoreFragment'},
    }

    def __init__(self, **kwargs):
        super(UserFragment, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.secret_store = kwargs.get('secret_store', None)
