# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .update_resource_py3 import UpdateResource


class VirtualNetworkFragment(UpdateResource):
    """A virtual network.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param allowed_subnets: The allowed subnets of the virtual network.
    :type allowed_subnets: list[~azure.mgmt.devtestlabs.models.SubnetFragment]
    :param description: The description of the virtual network.
    :type description: str
    :param external_provider_resource_id: The Microsoft.Network resource
     identifier of the virtual network.
    :type external_provider_resource_id: str
    :param subnet_overrides: The subnet overrides of the virtual network.
    :type subnet_overrides:
     list[~azure.mgmt.devtestlabs.models.SubnetOverrideFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'allowed_subnets': {'key': 'properties.allowedSubnets', 'type': '[SubnetFragment]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_provider_resource_id': {'key': 'properties.externalProviderResourceId', 'type': 'str'},
        'subnet_overrides': {'key': 'properties.subnetOverrides', 'type': '[SubnetOverrideFragment]'},
    }

    def __init__(self, *, tags=None, allowed_subnets=None, description: str=None, external_provider_resource_id: str=None, subnet_overrides=None, **kwargs) -> None:
        super(VirtualNetworkFragment, self).__init__(tags=tags, **kwargs)
        self.allowed_subnets = allowed_subnets
        self.description = description
        self.external_provider_resource_id = external_provider_resource_id
        self.subnet_overrides = subnet_overrides
