# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class SBSubscription(Resource):
    """Description of subscription resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar message_count: Number of messages.
    :vartype message_count: long
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar accessed_at: Last time there was a receive request to this
     subscription.
    :vartype accessed_at: datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    :ivar count_details: Message count details
    :vartype count_details: ~azure.mgmt.servicebus.models.MessageCountDetails
    :param lock_duration: ISO 8061 lock duration timespan for the
     subscription. The default value is 1 minute.
    :type lock_duration: timedelta
    :param requires_session: Value indicating if a subscription supports the
     concept of sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8061 Default message timespan to
     live value. This is the duration after which the message expires, starting
     from when the message is sent to Service Bus. This is the default value
     used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: timedelta
    :param dead_lettering_on_filter_evaluation_exceptions: Value that
     indicates whether a subscription has dead letter support on filter
     evaluation exceptions.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param dead_lettering_on_message_expiration: Value that indicates whether
     a subscription has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan
     structure that defines the duration of the duplicate detection history.
     The default value is 10 minutes.
    :type duplicate_detection_history_time_window: timedelta
    :param max_delivery_count: Number of maximum deliveries.
    :type max_delivery_count: int
    :param status: Enumerates the possible values for the status of a
     messaging entity. Possible values include: 'Active', 'Disabled',
     'Restoring', 'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting',
     'Renaming', 'Unknown'
    :type status: str or ~azure.mgmt.servicebus.models.EntityStatus
    :param enable_batched_operations: Value that indicates whether server-side
     batched operations are enabled.
    :type enable_batched_operations: bool
    :param auto_delete_on_idle: ISO 8061 timeSpan idle interval after which
     the topic is automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: timedelta
    :param forward_to: Queue/Topic name to forward the messages
    :type forward_to: str
    :param forward_dead_lettered_messages_to: Queue/Topic name to forward the
     Dead Letter message
    :type forward_dead_lettered_messages_to: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'message_count': {'readonly': True},
        'created_at': {'readonly': True},
        'accessed_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'count_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'duration'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'duration'},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'properties.deadLetteringOnFilterEvaluationExceptions', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'duration'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'duration'},
        'forward_to': {'key': 'properties.forwardTo', 'type': 'str'},
        'forward_dead_lettered_messages_to': {'key': 'properties.forwardDeadLetteredMessagesTo', 'type': 'str'},
    }

    def __init__(self, *, lock_duration=None, requires_session: bool=None, default_message_time_to_live=None, dead_lettering_on_filter_evaluation_exceptions: bool=None, dead_lettering_on_message_expiration: bool=None, duplicate_detection_history_time_window=None, max_delivery_count: int=None, status=None, enable_batched_operations: bool=None, auto_delete_on_idle=None, forward_to: str=None, forward_dead_lettered_messages_to: str=None, **kwargs) -> None:
        super(SBSubscription, self).__init__(**kwargs)
        self.message_count = None
        self.created_at = None
        self.accessed_at = None
        self.updated_at = None
        self.count_details = None
        self.lock_duration = lock_duration
        self.requires_session = requires_session
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_filter_evaluation_exceptions = dead_lettering_on_filter_evaluation_exceptions
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.max_delivery_count = max_delivery_count
        self.status = status
        self.enable_batched_operations = enable_batched_operations
        self.auto_delete_on_idle = auto_delete_on_idle
        self.forward_to = forward_to
        self.forward_dead_lettered_messages_to = forward_dead_lettered_messages_to
