# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PreAuthorizedApplication(Model):
    """Contains information about pre authorized client application.

    :param app_id: Represents the application id.
    :type app_id: str
    :param permissions: Collection of required app permissions/entitlements
     from the resource application.
    :type permissions:
     list[~azure.graphrbac.models.PreAuthorizedApplicationPermission]
    :param extensions: Collection of extensions from the resource application.
    :type extensions:
     list[~azure.graphrbac.models.PreAuthorizedApplicationExtension]
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': '[PreAuthorizedApplicationPermission]'},
        'extensions': {'key': 'extensions', 'type': '[PreAuthorizedApplicationExtension]'},
    }

    def __init__(self, **kwargs):
        super(PreAuthorizedApplication, self).__init__(**kwargs)
        self.app_id = kwargs.get('app_id', None)
        self.permissions = kwargs.get('permissions', None)
        self.extensions = kwargs.get('extensions', None)
