# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SourceControlSecurityTokenProperties(Model):
    """SourceControlSecurityTokenProperties.

    :param access_token: The access token.
    :type access_token: str
    :param refresh_token: The refresh token.
    :type refresh_token: str
    :param token_type: The token type. Must be either PersonalAccessToken or
     Oauth. Possible values include: 'PersonalAccessToken', 'Oauth'
    :type token_type: str or ~azure.mgmt.automation.models.TokenType
    """

    _validation = {
        'access_token': {'max_length': 1024},
        'refresh_token': {'max_length': 1024},
    }

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'refresh_token': {'key': 'refreshToken', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
    }

    def __init__(self, *, access_token: str=None, refresh_token: str=None, token_type=None, **kwargs) -> None:
        super(SourceControlSecurityTokenProperties, self).__init__(**kwargs)
        self.access_token = access_token
        self.refresh_token = refresh_token
        self.token_type = token_type
