# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .update_resource import UpdateResource


class CustomImageFragment(UpdateResource):
    """A custom image.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVmFragment
    :param vhd: The VHD from which the image is to be created.
    :type vhd:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustomFragment
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom
     image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks
     present in the custom image
    :type data_disk_storage_info:
     list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfoFragment]
    :param custom_image_plan: Storage information about the plan related to
     this custom image
    :type custom_image_plan:
     ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlanFragment
    :param is_plan_authorized: Whether or not the custom images underlying
     offer/plan has been enabled for programmatic deployment
    :type is_plan_authorized: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVmFragment'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustomFragment'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfoFragment]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlanFragment'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CustomImageFragment, self).__init__(**kwargs)
        self.vm = kwargs.get('vm', None)
        self.vhd = kwargs.get('vhd', None)
        self.description = kwargs.get('description', None)
        self.author = kwargs.get('author', None)
        self.managed_image_id = kwargs.get('managed_image_id', None)
        self.managed_snapshot_id = kwargs.get('managed_snapshot_id', None)
        self.data_disk_storage_info = kwargs.get('data_disk_storage_info', None)
        self.custom_image_plan = kwargs.get('custom_image_plan', None)
        self.is_plan_authorized = kwargs.get('is_plan_authorized', None)
