# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from .. import models
import uuid


class SubscriptionClientOperationsMixin(object):

    def check_resource_name(
            self, name, type, custom_headers=None, raw=False, **operation_config):
        """Checks resource name validity.

        A resource name is valid if it is not a reserved word, does not
        contains a reserved word and does not start with a reserved word.

        :param name: Name of the resource
        :type name: str
        :param type: The type of the resource
        :type type: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CheckResourceNameResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.resource.subscriptions.v2016_06_01.models.CheckResourceNameResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.resource.subscriptions.v2016_06_01.models.ErrorResponseException>`
        """
        resource_name_definition = None
        if name is not None or type is not None:
            resource_name_definition = models.ResourceName(name=name, type=type)

        # Construct URL
        url = self.check_resource_name.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        if resource_name_definition is not None:
            body_content = self._serialize.body(resource_name_definition, 'ResourceName')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('CheckResourceNameResult', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    check_resource_name.metadata = {'url': '/providers/Microsoft.Resources/checkResourceName'}
