// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListThingGroupsForThingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The thing name.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListThingGroupsForThingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListThingGroupsForThingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListThingGroupsForThingInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingGroupsForThingInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListThingGroupsForThingOutput struct {
	_ struct{} `type:"structure"`

	// The token used to get the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The thing groups.
	ThingGroups []GroupNameAndArn `locationName:"thingGroups" type:"list"`
}

// String returns the string representation
func (s ListThingGroupsForThingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListThingGroupsForThingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingGroups != nil {
		v := s.ThingGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "thingGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListThingGroupsForThing = "ListThingGroupsForThing"

// ListThingGroupsForThingRequest returns a request value for making API operation for
// AWS IoT.
//
// List the thing groups to which the specified thing belongs.
//
//    // Example sending a request using ListThingGroupsForThingRequest.
//    req := client.ListThingGroupsForThingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListThingGroupsForThingRequest(input *ListThingGroupsForThingInput) ListThingGroupsForThingRequest {
	op := &aws.Operation{
		Name:       opListThingGroupsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/thing-groups",
	}

	if input == nil {
		input = &ListThingGroupsForThingInput{}
	}

	req := c.newRequest(op, input, &ListThingGroupsForThingOutput{})
	return ListThingGroupsForThingRequest{Request: req, Input: input, Copy: c.ListThingGroupsForThingRequest}
}

// ListThingGroupsForThingRequest is the request type for the
// ListThingGroupsForThing API operation.
type ListThingGroupsForThingRequest struct {
	*aws.Request
	Input *ListThingGroupsForThingInput
	Copy  func(*ListThingGroupsForThingInput) ListThingGroupsForThingRequest
}

// Send marshals and sends the ListThingGroupsForThing API request.
func (r ListThingGroupsForThingRequest) Send(ctx context.Context) (*ListThingGroupsForThingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListThingGroupsForThingResponse{
		ListThingGroupsForThingOutput: r.Request.Data.(*ListThingGroupsForThingOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListThingGroupsForThingResponse is the response type for the
// ListThingGroupsForThing API operation.
type ListThingGroupsForThingResponse struct {
	*ListThingGroupsForThingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListThingGroupsForThing request.
func (r *ListThingGroupsForThingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
