// lib-ui candidate

import React from 'react';
import { TextContent, Text, TextVariants } from '@patternfly/react-core';
import spacing from '@patternfly/react-styles/css/utilities/Spacing/spacing';

interface IWizardStepContainerProps {
  title: string;
  children: React.ReactNode;
}

const WizardStepContainer: React.FunctionComponent<IWizardStepContainerProps> = ({
  title,
  children,
}: IWizardStepContainerProps) => (
  <>
    <TextContent className={spacing.mbMd}>
      <Text component={TextVariants.h2}>{title}</Text>
    </TextContent>
    {children}
  </>
);

export default WizardStepContainer;
