import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/JumpLinks/jump-links';
import { JumpLinksItem } from './JumpLinksItem';
const getScrollItems = (children, hasScrollSpy) => React.Children.toArray(children).map((child) => {
    if (hasScrollSpy && typeof document !== 'undefined' && child.type === JumpLinksItem) {
        const scrollNode = child.props.node || child.props.href;
        if (typeof scrollNode === 'string' && typeof document !== 'undefined') {
            return document.querySelector(scrollNode);
        }
        else if (scrollNode instanceof HTMLElement) {
            return scrollNode;
        }
    }
    return null;
});
export const JumpLinks = (_a) => {
    var { isCentered, isVertical, children, label, 'aria-label': ariaLabel = typeof label === 'string' ? label : null, scrollableSelector, activeIndex: activeIndexProp = 0 } = _a, props = __rest(_a, ["isCentered", "isVertical", "children", "label", 'aria-label', "scrollableSelector", "activeIndex"]);
    const hasScrollSpy = Boolean(scrollableSelector);
    const [scrollItems, setScrollItems] = React.useState(getScrollItems(children, hasScrollSpy));
    const [activeIndex, setActiveIndex] = React.useState(activeIndexProp);
    if (hasScrollSpy) {
        React.useEffect(() => {
            if (typeof window === 'undefined') {
                return;
            }
            const scrollableElement = document.querySelector(scrollableSelector);
            if (!(scrollableElement instanceof HTMLElement)) {
                return;
            }
            function scrollSpy() {
                const scrollPosition = scrollableElement.scrollTop;
                window.requestAnimationFrame(() => {
                    let newScrollItems = scrollItems;
                    // Items might have rendered after this component. Do a quick refresh.
                    if (!newScrollItems[0]) {
                        newScrollItems = getScrollItems(children, hasScrollSpy);
                        setScrollItems(newScrollItems);
                    }
                    const scrollElements = newScrollItems
                        .map((e, index) => ({
                        y: e ? e.offsetTop : null,
                        index
                    }))
                        .filter(({ y }) => y !== null)
                        .sort((e1, e2) => e2.y - e1.y);
                    for (const { y, index } of scrollElements) {
                        if (scrollPosition >= y) {
                            return setActiveIndex(index);
                        }
                    }
                });
            }
            if (scrollableElement) {
                scrollSpy();
                scrollableElement.addEventListener('scroll', scrollSpy);
            }
            return () => scrollableElement.removeEventListener('scroll', scrollSpy);
        }, [scrollItems, hasScrollSpy]);
    }
    return (React.createElement("nav", Object.assign({ className: css(styles.jumpLinks, isCentered && styles.modifiers.center, isVertical && styles.modifiers.vertical), "aria-label": ariaLabel }, props),
        React.createElement("div", { className: styles.jumpLinksMain },
            label && React.createElement("div", { className: styles.jumpLinksLabel }, label),
            React.createElement("ul", { className: styles.jumpLinksList }, React.Children.map(children, (child, i) => {
                if (hasScrollSpy && child.type === JumpLinksItem) {
                    const { onClick: onClickProp, isActive: isActiveProp } = child.props;
                    const scrollItem = scrollItems[i];
                    return React.cloneElement(child, {
                        onClick(ev) {
                            // Items might have rendered after this component. Do a quick refresh.
                            let newScrollItems;
                            if (!scrollItem) {
                                newScrollItems = getScrollItems(children, hasScrollSpy);
                                setScrollItems(newScrollItems);
                            }
                            const newScrollItem = scrollItem || newScrollItems[i];
                            if (newScrollItem) {
                                newScrollItem.scrollIntoView();
                                newScrollItem.focus();
                                ev.preventDefault();
                            }
                            if (onClickProp) {
                                onClickProp(ev);
                            }
                        },
                        isActive: isActiveProp || activeIndex === i
                    });
                }
                return child;
            })))));
};
JumpLinks.displayName = 'JumpLinks';
//# sourceMappingURL=JumpLinks.js.map