import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Menu/menu';
import { css } from '@patternfly/react-styles';
import { getOUIAProps, getDefaultOUIAId } from '../../helpers';
import { SearchInput } from '../SearchInput';
import { Divider } from '../Divider';
import { MenuContext } from './MenuContext';
class MenuBase extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            ouiaStateId: getDefaultOUIAId(Menu.displayName),
            searchInputValue: ''
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, children, className, onSelect, selected = null, onActionClick, onSearchInputChange, ouiaId, ouiaSafe, containsFlyout, hasSearchInput, activeItemId = null, innerRef } = _a, props = __rest(_a, ['aria-label', "children", "className", "onSelect", "selected", "onActionClick", "onSearchInputChange", "ouiaId", "ouiaSafe", "containsFlyout", "hasSearchInput", "activeItemId", "innerRef"]);
        return (React.createElement(MenuContext.Provider, { value: { onSelect, onActionClick, activeItemId, selected } },
            React.createElement("div", Object.assign({ className: css(styles.menu, containsFlyout && styles.modifiers.flyout, className), "aria-label": ariaLabel || containsFlyout ? 'Local' : 'Global', ref: innerRef }, getOUIAProps(Menu.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), props),
                hasSearchInput && (React.createElement(React.Fragment, null,
                    React.createElement("div", { className: styles.menuSearch },
                        React.createElement(SearchInput, { value: this.state.searchInputValue, onChange: (value, event) => {
                                this.setState({ searchInputValue: value });
                                onSearchInputChange(event, value);
                            }, onClear: event => {
                                this.setState({ searchInputValue: '' });
                                onSearchInputChange(event, '');
                            } })),
                    React.createElement(Divider, null))),
                React.createElement("div", { className: css(styles.menuContent) }, children))));
    }
}
MenuBase.defaultProps = {
    ouiaSafe: true
};
export const Menu = React.forwardRef((props, ref) => (React.createElement(MenuBase, Object.assign({}, props, { innerRef: ref }))));
Menu.displayName = 'Menu';
//# sourceMappingURL=Menu.js.map