import * as React from 'react';
import { FormGroupProps, TextArea, TextAreaProps, TextInput, TextInputProps } from '@patternfly/react-core';
import { IValidatedFormField } from '../../hooks/useFormState';
interface IValidatedTextInputProps extends Pick<FormGroupProps, 'label' | 'fieldId' | 'isRequired'>, Pick<TextInputProps, 'type'> {
    /** A field returned from useFormField() or useFormState().fields.* */
    field: IValidatedFormField<string> | IValidatedFormField<string | undefined>;
    /** Either a TextInput or TextArea from @patternfly/react-core. Defaults to TextInput */
    component?: typeof TextInput | typeof TextArea;
    /** Any extra props for the PatternFly FormGroup */
    formGroupProps?: Partial<FormGroupProps>;
    /** Any extra props for the PatternFly TextInput or TextArea */
    inputProps?: Partial<TextInputProps> | Partial<TextAreaProps>;
}
export declare const ValidatedTextInput: React.FunctionComponent<IValidatedTextInputProps>;
export {};
