import { KubeResource, OAuthClient, TokenExpiryHandler } from './resources/common';
import type { ResponseType } from 'axios';
export interface IClusterClient {
    list(resource: KubeResource, params?: object): Promise<any>;
    get(resource: KubeResource, name: string, params?: object): Promise<any>;
    put(resource: KubeResource, name: string, updatedObject: object, params?: object): Promise<any>;
    patch(resource: KubeResource, name: string, patch: object, params?: object): Promise<any>;
    create(resource: KubeResource, newObject: object, params?: object): Promise<any>;
    delete(resource: KubeResource, name: string, params?: object): Promise<any>;
    apiRoot: string;
    setTokenExpiryHandler: (handler: TokenExpiryHandler, tokenExpiryTime: number) => void;
}
export declare class ClientTokenExpiredError extends Error {
    constructor();
}
export declare class ClusterClient extends OAuthClient {
    apiRoot: string;
    private requester;
    private patchRequester;
    constructor(apiRoot: string, token: string, customResponseType?: ResponseType);
    list: (resource: KubeResource, params?: object | undefined) => Promise<any>;
    get: (resource: KubeResource, name: string, params?: object | undefined) => Promise<any>;
    put: (resource: KubeResource, name: string, updatedObject: object, params?: object | undefined) => Promise<any>;
    patch: (resource: KubeResource, name: string, patch: object, params?: object | undefined) => Promise<any>;
    create: (resource: KubeResource, newObject: object, params?: object | undefined) => Promise<any>;
    delete: (resource: KubeResource, name: string, params?: object | undefined) => Promise<any>;
}
