package quota

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RequestStatusClient is the microsoft Azure Quota Resource Provider
type RequestStatusClient struct {
	BaseClient
}

// NewRequestStatusClient creates an instance of the RequestStatusClient client.
func NewRequestStatusClient() RequestStatusClient {
	return NewRequestStatusClientWithBaseURI(DefaultBaseURI)
}

// NewRequestStatusClientWithBaseURI creates an instance of the RequestStatusClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRequestStatusClientWithBaseURI(baseURI string) RequestStatusClient {
	return RequestStatusClient{NewWithBaseURI(baseURI)}
}

// Get get the quota request details and status by quota request ID for the resources of the resource provider at a
// specific location. The quota request ID **id** is returned in the response of the PUT operation.
// Parameters:
// ID - quota request ID.
// scope - the target Azure resource URI. For example,
// `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/`.
// This is the target Azure resource URI for the List GET operation. If a `{resourceName}` is added after
// `/quotas`, then it's the target Azure resource URI in the GET operation for the specific resource.
func (client RequestStatusClient) Get(ctx context.Context, ID string, scope string) (result RequestDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestStatusClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, ID, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RequestStatusClient) GetPreparer(ctx context.Context, ID string, scope string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":    autorest.Encode("path", ID),
		"scope": scope,
	}

	const APIVersion = "2021-03-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Quota/quotaRequests/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RequestStatusClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RequestStatusClient) GetResponder(resp *http.Response) (result RequestDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List for the specified scope, get the current quota requests for a one year period ending at the time is made. Use
// the **oData** filter to select quota requests.
// Parameters:
// scope - the target Azure resource URI. For example,
// `/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/qms-test/providers/Microsoft.Batch/batchAccounts/testAccount/`.
// This is the target Azure resource URI for the List GET operation. If a `{resourceName}` is added after
// `/quotas`, then it's the target Azure resource URI in the GET operation for the specific resource.
// filter - | Field                    | Supported operators
// |---------------------|------------------------
//
// |requestSubmitTime | ge, le, eq, gt, lt
// |provisioningState eq {QuotaRequestState}
// |resourceName eq {resourceName}
// top - number of records to return.
// skiptoken - the **Skiptoken** parameter is used only if a previous operation returned a partial result. If a
// previous response contains a **nextLink** element, its value includes a **skiptoken** parameter that
// specifies a starting point to use for subsequent calls.
func (client RequestStatusClient) List(ctx context.Context, scope string, filter string, top *int32, skiptoken string) (result RequestDetailsListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestStatusClient.List")
		defer func() {
			sc := -1
			if result.rdl.Response.Response != nil {
				sc = result.rdl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("quota.RequestStatusClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, scope, filter, top, skiptoken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rdl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "List", resp, "Failure sending request")
		return
	}

	result.rdl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "List", resp, "Failure responding to request")
		return
	}
	if result.rdl.hasNextLink() && result.rdl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client RequestStatusClient) ListPreparer(ctx context.Context, scope string, filter string, top *int32, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2021-03-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Quota/quotaRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client RequestStatusClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client RequestStatusClient) ListResponder(resp *http.Response) (result RequestDetailsList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client RequestStatusClient) listNextResults(ctx context.Context, lastResults RequestDetailsList) (result RequestDetailsList, err error) {
	req, err := lastResults.requestDetailsListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "quota.RequestStatusClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "quota.RequestStatusClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "quota.RequestStatusClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client RequestStatusClient) ListComplete(ctx context.Context, scope string, filter string, top *int32, skiptoken string) (result RequestDetailsListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RequestStatusClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, scope, filter, top, skiptoken)
	return
}
