// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateServer = "CreateServer"

// CreateServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServer for more information on using the CreateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServerRequest method.
//    req, resp := client.CreateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServerRequest(input *CreateServerInput) (req *request.Request, output *CreateServerOutput) {
	op := &request.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	output = &CreateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServer API operation for AWS Transfer for SFTP.
//
// Instantiates an autoscaling virtual server based on Secure File Transfer
// Protocol (SFTP) in AWS. The call returns the ServerId property assigned by
// the service to the newly created server. Reference this ServerId property
// when you make updates to your server, or work with users.
//
// The response returns the ServerId value for the newly created server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation CreateServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Transfer) CreateServer(input *CreateServerInput) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	return out, req.Send()
}

// CreateServerWithContext is the same as CreateServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateServerWithContext(ctx aws.Context, input *CreateServerInput, opts ...request.Option) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for AWS Transfer for SFTP.
//
// Adds a user and associate them with an existing Secure File Transfer Protocol
// (SFTP) server. Using parameters for CreateUser, you can specify the user
// name, set the home directory, store the user's public key, and assign the
// user's AWS Identity and Access Management (IAM) role. You can also optionally
// add a scope-down policy, and assign metadata with tags that can be used to
// group and search for users.
//
// The response returns the UserName and ServerId values of the new user for
// that server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation CreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The requested resource does not exist.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateUser
func (c *Transfer) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServer for more information on using the DeleteServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServerRequest method.
//    req, resp := client.DeleteServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServerRequest(input *DeleteServerInput) (req *request.Request, output *DeleteServerOutput) {
	op := &request.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	output = &DeleteServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServer API operation for AWS Transfer for SFTP.
//
// Deletes the Secure File Transfer Protocol (SFTP) server that you specify.
// If you used SERVICE_MANAGED as your IdentityProviderType, you need to delete
// all users associated with this server before deleting the server itself
//
// No response returns from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation DeleteServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteServer
func (c *Transfer) DeleteServer(input *DeleteServerInput) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	return out, req.Send()
}

// DeleteServerWithContext is the same as DeleteServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteServerWithContext(ctx aws.Context, input *DeleteServerInput, opts ...request.Option) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSshPublicKey = "DeleteSshPublicKey"

// DeleteSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSshPublicKey for more information on using the DeleteSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSshPublicKeyRequest method.
//    req, resp := client.DeleteSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKeyRequest(input *DeleteSshPublicKeyInput) (req *request.Request, output *DeleteSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSshPublicKeyInput{}
	}

	output = &DeleteSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSshPublicKey API operation for AWS Transfer for SFTP.
//
// Deletes a user's Secure Shell (SSH) public key.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation DeleteSshPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteSshPublicKey
func (c *Transfer) DeleteSshPublicKey(input *DeleteSshPublicKeyInput) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	return out, req.Send()
}

// DeleteSshPublicKeyWithContext is the same as DeleteSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteSshPublicKeyWithContext(ctx aws.Context, input *DeleteSshPublicKeyInput, opts ...request.Option) (*DeleteSshPublicKeyOutput, error) {
	req, out := c.DeleteSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AWS Transfer for SFTP.
//
// Deletes the user belonging to the server you specify.
//
// No response returns from this call.
//
// When you delete a user from a server, the user's information is lost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DeleteUser
func (c *Transfer) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServer = "DescribeServer"

// DescribeServerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServer for more information on using the DescribeServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServerRequest method.
//    req, resp := client.DescribeServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServerRequest(input *DescribeServerInput) (req *request.Request, output *DescribeServerOutput) {
	op := &request.Operation{
		Name:       opDescribeServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServerInput{}
	}

	output = &DescribeServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServer API operation for AWS Transfer for SFTP.
//
// Describes the server that you specify by passing the ServerId parameter.
//
// The response contains a description of the server's properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation DescribeServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeServer
func (c *Transfer) DescribeServer(input *DescribeServerInput) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	return out, req.Send()
}

// DescribeServerWithContext is the same as DescribeServer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeServerWithContext(ctx aws.Context, input *DescribeServerInput, opts ...request.Option) (*DescribeServerOutput, error) {
	req, out := c.DescribeServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for AWS Transfer for SFTP.
//
// Describes the user assigned to a specific server, as identified by its ServerId
// property.
//
// The response from this call returns the properties of the user associated
// with the ServerId value that was specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation DescribeUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/DescribeUser
func (c *Transfer) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportSshPublicKey = "ImportSshPublicKey"

// ImportSshPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the ImportSshPublicKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportSshPublicKey for more information on using the ImportSshPublicKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportSshPublicKeyRequest method.
//    req, resp := client.ImportSshPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKeyRequest(input *ImportSshPublicKeyInput) (req *request.Request, output *ImportSshPublicKeyOutput) {
	op := &request.Operation{
		Name:       opImportSshPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportSshPublicKeyInput{}
	}

	output = &ImportSshPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportSshPublicKey API operation for AWS Transfer for SFTP.
//
// Adds a Secure Shell (SSH) public key to a user account identified by a UserName
// value assigned to a specific server, identified by ServerId.
//
// The response returns the UserName value, the ServerId value, and the name
// of the SshPublicKeyId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation ImportSshPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceExistsException "ResourceExistsException"
//   The requested resource does not exist.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ImportSshPublicKey
func (c *Transfer) ImportSshPublicKey(input *ImportSshPublicKeyInput) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	return out, req.Send()
}

// ImportSshPublicKeyWithContext is the same as ImportSshPublicKey with the addition of
// the ability to pass a context and additional request options.
//
// See ImportSshPublicKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ImportSshPublicKeyWithContext(ctx aws.Context, input *ImportSshPublicKeyInput, opts ...request.Option) (*ImportSshPublicKeyOutput, error) {
	req, out := c.ImportSshPublicKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListServers = "ListServers"

// ListServersRequest generates a "aws/request.Request" representing the
// client's request for the ListServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServers for more information on using the ListServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServersRequest method.
//    req, resp := client.ListServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServersRequest(input *ListServersInput) (req *request.Request, output *ListServersOutput) {
	op := &request.Operation{
		Name:       opListServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServersInput{}
	}

	output = &ListServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServers API operation for AWS Transfer for SFTP.
//
// Lists the Secure File Transfer Protocol (SFTP) servers that are associated
// with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation ListServers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken parameter that was passed is invalid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListServers
func (c *Transfer) ListServers(input *ListServersInput) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	return out, req.Send()
}

// ListServersWithContext is the same as ListServers with the addition of
// the ability to pass a context and additional request options.
//
// See ListServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListServersWithContext(ctx aws.Context, input *ListServersInput, opts ...request.Option) (*ListServersOutput, error) {
	req, out := c.ListServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Transfer for SFTP.
//
// Lists all of the tags associated with the Amazon Resource Number (ARN) you
// specify. The resource can be a user, server, or role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken parameter that was passed is invalid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListTagsForResource
func (c *Transfer) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AWS Transfer for SFTP.
//
// Lists the users for the server that you specify by passing the ServerId parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The NextToken parameter that was passed is invalid.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListUsers
func (c *Transfer) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartServer = "StartServer"

// StartServerRequest generates a "aws/request.Request" representing the
// client's request for the StartServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartServer for more information on using the StartServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartServerRequest method.
//    req, resp := client.StartServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServerRequest(input *StartServerInput) (req *request.Request, output *StartServerOutput) {
	op := &request.Operation{
		Name:       opStartServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartServerInput{}
	}

	output = &StartServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartServer API operation for AWS Transfer for SFTP.
//
// Changes the state of a Secure File Transfer Protocol (SFTP) server from OFFLINE
// to ONLINE. It has no impact on an SFTP server that is already ONLINE. An
// ONLINE server can accept and process file transfer jobs.
//
// The state of STARTING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully online. The values of START_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation StartServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StartServer
func (c *Transfer) StartServer(input *StartServerInput) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	return out, req.Send()
}

// StartServerWithContext is the same as StartServer with the addition of
// the ability to pass a context and additional request options.
//
// See StartServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StartServerWithContext(ctx aws.Context, input *StartServerInput, opts ...request.Option) (*StartServerOutput, error) {
	req, out := c.StartServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopServer = "StopServer"

// StopServerRequest generates a "aws/request.Request" representing the
// client's request for the StopServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopServer for more information on using the StopServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopServerRequest method.
//    req, resp := client.StopServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServerRequest(input *StopServerInput) (req *request.Request, output *StopServerOutput) {
	op := &request.Operation{
		Name:       opStopServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopServerInput{}
	}

	output = &StopServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopServer API operation for AWS Transfer for SFTP.
//
// Changes the state of an SFTP server from ONLINE to OFFLINE. An OFFLINE server
// cannot accept and process file transfer jobs. Information tied to your server
// such as server and user properties are not affected by stopping your server.
// Stopping a server will not reduce or impact your Secure File Transfer Protocol
// (SFTP) endpoint billing.
//
// The states of STOPPING indicates that the server is in an intermediate state,
// either not fully able to respond, or not fully offline. The values of STOP_FAILED
// can indicate an error condition.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation StopServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/StopServer
func (c *Transfer) StopServer(input *StopServerInput) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	return out, req.Send()
}

// StopServerWithContext is the same as StopServer with the addition of
// the ability to pass a context and additional request options.
//
// See StopServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) StopServerWithContext(ctx aws.Context, input *StopServerInput, opts ...request.Option) (*StopServerOutput, error) {
	req, out := c.StopServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Transfer for SFTP.
//
// Attaches a key-value pair to a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// There is no response returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TagResource
func (c *Transfer) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestIdentityProvider = "TestIdentityProvider"

// TestIdentityProviderRequest generates a "aws/request.Request" representing the
// client's request for the TestIdentityProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestIdentityProvider for more information on using the TestIdentityProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestIdentityProviderRequest method.
//    req, resp := client.TestIdentityProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProviderRequest(input *TestIdentityProviderInput) (req *request.Request, output *TestIdentityProviderOutput) {
	op := &request.Operation{
		Name:       opTestIdentityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestIdentityProviderInput{}
	}

	output = &TestIdentityProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestIdentityProvider API operation for AWS Transfer for SFTP.
//
// If the IdentityProviderType of the server is API_Gateway, tests whether your
// API Gateway is set up successfully. We highly recommend that you call this
// method to test your authentication method as soon as you create your server.
// By doing so, you can troubleshoot issues with the API Gateway integration
// to ensure that your users can successfully use the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation TestIdentityProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/TestIdentityProvider
func (c *Transfer) TestIdentityProvider(input *TestIdentityProviderInput) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	return out, req.Send()
}

// TestIdentityProviderWithContext is the same as TestIdentityProvider with the addition of
// the ability to pass a context and additional request options.
//
// See TestIdentityProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) TestIdentityProviderWithContext(ctx aws.Context, input *TestIdentityProviderInput, opts ...request.Option) (*TestIdentityProviderOutput, error) {
	req, out := c.TestIdentityProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Transfer for SFTP.
//
// Detaches a key-value pair from a resource, as identified by its Amazon Resource
// Name (ARN). Resources are users, servers, roles, and other entities.
//
// No response is returned from this call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UntagResource
func (c *Transfer) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServer for more information on using the UpdateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServerRequest method.
//    req, resp := client.UpdateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServerRequest(input *UpdateServerInput) (req *request.Request, output *UpdateServerOutput) {
	op := &request.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	output = &UpdateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServer API operation for AWS Transfer for SFTP.
//
// Updates the server properties after that server has been created.
//
// The UpdateServer call returns the ServerId of the Secure File Transfer Protocol
// (SFTP) server you updated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation UpdateServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateServer
func (c *Transfer) UpdateServer(input *UpdateServerInput) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	return out, req.Send()
}

// UpdateServerWithContext is the same as UpdateServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateServerWithContext(ctx aws.Context, input *UpdateServerInput, opts ...request.Option) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for AWS Transfer for SFTP.
//
// Assigns new properties to a user. Parameters you pass modify any or all of
// the following: the home directory, role, and policy for the UserName and
// ServerId you specify.
//
// The response returns the ServerId and the UserName for the updated user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Transfer for SFTP's
// API operation UpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   The request has failed because the AWS Transfer for SFTP service is not available.
//
//   * ErrCodeInternalServiceError "InternalServiceError"
//   This exception is thrown when an error occurs in the AWS Transfer for SFTP
//   service.
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   This exception is thrown when the client submits a malformed request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when a resource is not found by the AWS Transfer
//   for SFTP service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/UpdateUser
func (c *Transfer) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Transfer) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// An array containing all of the information required to call a customer-supplied
	// authentication API. This parameter is not required when the IdentityProviderType
	// value of server that is created uses the SERVICE_MANAGED authentication method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// The mode of authentication enabled for this service. The default value is
	// SERVICE_MANAGED, which allows you to store and access SFTP user credentials
	// within the service. An IdentityProviderType value of API_GATEWAY indicates
	// that user authentication requires a call to an API Gateway endpoint URL provided
	// by you to integrate an identity provider of your choice.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// A value that allows the service to write your SFTP users’ activity to your
	// Amazon CloudWatch logs for monitoring and auditing purposes.
	LoggingRole *string `type:"string"`

	// Key-value pairs that can be used to group and search for servers.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServerInput"}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *CreateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *CreateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *CreateServerInput) SetIdentityProviderType(v string) *CreateServerInput {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *CreateServerInput) SetLoggingRole(v string) *CreateServerInput {
	s.LoggingRole = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServerInput) SetTags(v []*Tag) *CreateServerInput {
	s.Tags = v
	return s
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The service-assigned ID of the SFTP server that is created.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateServerOutput) SetServerId(v string) *CreateServerOutput {
	s.ServerId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The landing directory (folder) for a user when they log in to the server
	// using their SFTP client. An example is /home/username.
	HomeDirectory *string `type:"string"`

	// A scope-down policy for your user so you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their
	// Amazon S3 bucket. Variables you can use inside this policy include ${Transfer:UserName},
	// ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	Policy *string `type:"string"`

	// The IAM role that controls your user’s access to your Amazon S3 bucket. The
	// policies attached to this role will determine the level of access you want
	// to provide your users when transferring files into and out of your Amazon
	// S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows the SFTP server to access your resources when servicing your
	// SFTP user’s transfer requests.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// A system-assigned unique identifier for an SFTP server instance. This is
	// the specific SFTP server that you added your user to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// The public portion of the Secure Shall (SSH) key used to authenticate the
	// user to the SFTP server.
	SshPublicKeyBody *string `type:"string"`

	// Key-value pairs that can be used to group and search for users. Tags are
	// metadata attached to users for any purpose.
	Tags []*Tag `min:"1" type:"list"`

	// A unique string that identifies a user and is associated with a server as
	// specified by the ServerId.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *CreateUserInput) SetHomeDirectory(v string) *CreateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateUserInput) SetPolicy(v string) *CreateUserInput {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateUserInput) SetRole(v string) *CreateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserInput) SetServerId(v string) *CreateUserInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *CreateUserInput) SetSshPublicKeyBody(v string) *CreateUserInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the SFTP server that the user is attached to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// A unique string that identifies a user account associated with an SFTP server.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *CreateUserOutput) SetServerId(v string) *CreateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserOutput) SetUserName(v string) *CreateUserOutput {
	s.UserName = &v
	return s
}

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// A unique system-assigned identifier for an SFTP server instance.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteServerInput) SetServerId(v string) *DeleteServerInput {
	s.ServerId = &v
	return s
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerOutput) GoString() string {
	return s.String()
}

type DeleteSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP)
	// server instance that has the user assigned to it.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// A unique identifier used to reference your user’s specific SSH key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `type:"string" required:"true"`

	// A unique string that identifies a user whose public key is being deleted.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.SshPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteSshPublicKeyInput) SetServerId(v string) *DeleteSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *DeleteSshPublicKeyInput) SetSshPublicKeyId(v string) *DeleteSshPublicKeyInput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteSshPublicKeyInput) SetUserName(v string) *DeleteSshPublicKeyInput {
	s.UserName = &v
	return s
}

type DeleteSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSshPublicKeyOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server instance that has
	// the user assigned to it.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// A unique string that identifies a user that is being deleted from the server.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DeleteUserInput) SetServerId(v string) *DeleteUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DescribeServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeServerInput) SetServerId(v string) *DescribeServerInput {
	s.ServerId = &v
	return s
}

type DescribeServerOutput struct {
	_ struct{} `type:"structure"`

	// An array containing the properties of the server with the ServerID you specified.
	//
	// Server is a required field
	Server *DescribedServer `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *DescribeServerOutput) SetServer(v *DescribedServer) *DescribeServerOutput {
	s.Server = v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that has this user
	// assigned.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// The name of the user assigned to one or more servers. User names are part
	// of the sign-in credentials to use the AWS Transfer service and perform file
	// transfer tasks.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserInput) SetServerId(v string) *DescribeUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUserInput) SetUserName(v string) *DescribeUserInput {
	s.UserName = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that has this user
	// assigned.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// An array containing the properties of the user account for the ServerID value
	// that you specified.
	//
	// User is a required field
	User *DescribedUser `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *DescribeUserOutput) SetServerId(v string) *DescribeUserOutput {
	s.ServerId = &v
	return s
}

// SetUser sets the User field's value.
func (s *DescribeUserOutput) SetUser(v *DescribedUser) *DescribeUserOutput {
	s.User = v
	return s
}

// Describe the properties of the server that was specified. Information returned
// includes: the server Amazon Resource Name (ARN), the authentication configuration
// and type, the logging role, server Id and state, and assigned tags or metadata.
type DescribedServer struct {
	_ struct{} `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) for the server to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies information to call a customer-supplied authentication API. This
	// field is not populated when the IdentityProviderType of the server is SERVICE_MANAGED>.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// This property defines the mode of authentication method enabled for this
	// service. A value of SERVICE_MANAGED, means that you are using this Server
	// to store and access SFTP user credentials within the service. A value of
	// API_GATEWAY indicates that you have integrated an API Gateway endpoint that
	// will be invoked for authenticating your user into the service.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// This property is an AWS Identity and Access Management (IAM) entity that
	// allows the server to turn on Amazon CloudWatch logging for Amazon S3 events.
	// When set, user activity can be view in your CloudWatch logs.
	LoggingRole *string `type:"string"`

	// This property is a unique system assigned identifier for the SFTP server
	// that you instantiate.
	ServerId *string `type:"string"`

	// The condition of the SFTP server for the server that was described. A value
	// of ONLINE indicates that the server can accept jobs and transfer files. A
	// State value of OFFLINE means that the server cannot perform file transfer
	// operations.
	//
	// The states of STARTING and STOPPING indicated that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// This property contains the key-value pairs that you can use to search for
	// and group servers that were assigned to the server that was described.
	Tags []*Tag `min:"1" type:"list"`

	// The number of users that are assigned to the SFTP server you specified with
	// the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedServer) SetArn(v string) *DescribedServer {
	s.Arn = &v
	return s
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *DescribedServer) SetIdentityProviderDetails(v *IdentityProviderDetails) *DescribedServer {
	s.IdentityProviderDetails = v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *DescribedServer) SetIdentityProviderType(v string) *DescribedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *DescribedServer) SetLoggingRole(v string) *DescribedServer {
	s.LoggingRole = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *DescribedServer) SetServerId(v string) *DescribedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribedServer) SetState(v string) *DescribedServer {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedServer) SetTags(v []*Tag) *DescribedServer {
	s.Tags = v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *DescribedServer) SetUserCount(v int64) *DescribedServer {
	s.UserCount = &v
	return s
}

// Returns properties of the user that you wish to describe.
type DescribedUser struct {
	_ struct{} `type:"structure"`

	// This property contains the unique Amazon Resource Name (ARN) for the user
	// that was requested to be described.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// This property specifies the landing directory (or folder) which is the location
	// that files are written to or read from in an Amazon S3 bucket for the described
	// user. An example would be: /bucket_name/home/username.
	HomeDirectory *string `type:"string"`

	// Specifies the name of the policy in use for the described user.
	Policy *string `type:"string"`

	// This property specifies the IAM role that controls your user’s access to
	// your Amazon S3 bucket. The policies attached to this role will determine
	// the level of access you want to provide your users when transferring files
	// into and out of your Amazon S3 bucket or buckets. The IAM role should also
	// contain a trust relationship that allows the SFTP server to access your resources
	// when servicing your SFTP user’s transfer requests.
	Role *string `type:"string"`

	// This property contains the public key portion of the Secure Shell (SSH) keys
	// stored for the described user.
	SshPublicKeys []*SshPublicKey `type:"list"`

	// This property contains the key-value pairs for the user requested. Tag can
	// be used to search for and group users for a variety of purposes.
	Tags []*Tag `min:"1" type:"list"`

	// This property is the name of the user that was requested to be described.
	// User names are used for authentication purposes. This is the string that
	// will be used by your user when they log in to your SFTP server.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s DescribedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribedUser) SetArn(v string) *DescribedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *DescribedUser) SetHomeDirectory(v string) *DescribedUser {
	s.HomeDirectory = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribedUser) SetPolicy(v string) *DescribedUser {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *DescribedUser) SetRole(v string) *DescribedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeys sets the SshPublicKeys field's value.
func (s *DescribedUser) SetSshPublicKeys(v []*SshPublicKey) *DescribedUser {
	s.SshPublicKeys = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribedUser) SetTags(v []*Tag) *DescribedUser {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribedUser) SetUserName(v string) *DescribedUser {
	s.UserName = &v
	return s
}

// Returns information related to the type of user authentication that is in
// use for a server's users. A server can only have one method of authentication.
type IdentityProviderDetails struct {
	_ struct{} `type:"structure"`

	// The Role parameter provides the type of InvocationRole used to authenticate
	// the user account.
	InvocationRole *string `type:"string"`

	// The IdentityProviderDetail parameter contains the location of the service
	// endpoint used to authenticate users.
	Url *string `type:"string"`
}

// String returns the string representation
func (s IdentityProviderDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityProviderDetails) GoString() string {
	return s.String()
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *IdentityProviderDetails) SetInvocationRole(v string) *IdentityProviderDetails {
	s.InvocationRole = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *IdentityProviderDetails) SetUrl(v string) *IdentityProviderDetails {
	s.Url = &v
	return s
}

type ImportSshPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// The public key portion of an SSH key pair.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// The name of the user account that is assigned to one or more servers.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSshPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportSshPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportSshPublicKeyInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.SshPublicKeyBody == nil {
		invalidParams.Add(request.NewErrParamRequired("SshPublicKeyBody"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyInput) SetServerId(v string) *ImportSshPublicKeyInput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *ImportSshPublicKeyInput) SetSshPublicKeyBody(v string) *ImportSshPublicKeyInput {
	s.SshPublicKeyBody = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyInput) SetUserName(v string) *ImportSshPublicKeyInput {
	s.UserName = &v
	return s
}

// This response identifies the user, server they belong to, and the identifier
// of the SSH public key associated with that user. A user can have more than
// one key on each server that they are associate with.
type ImportSshPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// This identifier is the name given to a public key by the system that was
	// imported.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `type:"string" required:"true"`

	// A user name assigned to the ServerID value that you specified.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportSshPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportSshPublicKeyOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *ImportSshPublicKeyOutput) SetServerId(v string) *ImportSshPublicKeyOutput {
	s.ServerId = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *ImportSshPublicKeyOutput) SetSshPublicKeyId(v string) *ImportSshPublicKeyOutput {
	s.SshPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ImportSshPublicKeyOutput) SetUserName(v string) *ImportSshPublicKeyOutput {
	s.UserName = &v
	return s
}

type ListServersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of servers to return as a response to the ListServers
	// query.
	MaxResults *int64 `min:"1" type:"integer"`

	// When additional results are obtained from the ListServers command, a NextToken
	// parameter is returned in the output. You can then pass the NextToken parameter
	// in a subsequent command to continue listing additional servers.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServersInput) SetMaxResults(v int64) *ListServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersInput) SetNextToken(v string) *ListServersInput {
	s.NextToken = &v
	return s
}

type ListServersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListServers operation, a NextToken
	// parameter is returned in the output. In a following command, you can pass
	// in the NextToken parameter to continue listing additional servers.
	NextToken *string `min:"1" type:"string"`

	// An array of servers that were listed.
	//
	// Servers is a required field
	Servers []*ListedServer `type:"list" required:"true"`
}

// String returns the string representation
func (s ListServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServersOutput) SetNextToken(v string) *ListServersOutput {
	s.NextToken = &v
	return s
}

// SetServers sets the Servers field's value.
func (s *ListServersOutput) SetServers(v []*ListedServer) *ListServersOutput {
	s.Servers = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Requests the tags associated with a particular Amazon Resource Name (ARN).
	// An ARN is an identifier for a specific AWS resource, such as a server, user,
	// or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Specifies the number of tags to return as a response to the ListTagsForResource
	// request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you request additional results from the ListTagsForResource call, a
	// NextToken parameter is returned in the input. You can then pass in a subsequent
	// command the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceInput) SetArn(v string) *ListTagsForResourceInput {
	s.Arn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// This value is the ARN you specified to list the tags of.
	Arn *string `min:"20" type:"string"`

	// When you can get additional results from the ListTagsForResource call, a
	// NextToken parameter is returned in the output. You can then pass in a subsequent
	// command the NextToken parameter to continue listing additional tags.
	NextToken *string `min:"1" type:"string"`

	// Key-value pairs that are assigned to a resource, usually for the purpose
	// of grouping and searching for items. Tags are metadata that you define that
	// you can use for any purpose.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListTagsForResourceOutput) SetArn(v string) *ListTagsForResourceOutput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of users to return as a response to the ListUsers request.
	MaxResults *int64 `min:"1" type:"integer"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP)
	// server that has users are assigned to it.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersInput) SetServerId(v string) *ListUsersInput {
	s.ServerId = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// When you can get additional results from the ListUsers call, a NextToken
	// parameter is returned in the output. You can then pass in a subsequent command
	// the NextToken parameter to continue listing additional users.
	NextToken *string `min:"1" type:"string"`

	// A system-assigned unique identifier for an SFTP server that the users are
	// assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// Returns the user accounts and their properties for the ServerId value that
	// you specify.
	//
	// Users is a required field
	Users []*ListedUser `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListUsersOutput) SetServerId(v string) *ListUsersOutput {
	s.ServerId = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*ListedUser) *ListUsersOutput {
	s.Users = v
	return s
}

// Returns properties of the server that was specified.
type ListedServer struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) for the server to be listed.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The authentication method used to validate a user for the server that was
	// specified. listed. This can include Secure Shell (SSH), user name and password
	// combinations, or your own custom authentication method. Valid values include
	// SERVICE_MANAGED or API_GATEWAY.
	IdentityProviderType *string `type:"string" enum:"IdentityProviderType"`

	// The AWS Identity and Access Management entity that allows the server to turn
	// on Amazon CloudWatch logging.
	LoggingRole *string `type:"string"`

	// This value is the unique system assigned identifier for the SFTP servers
	// that were listed.
	ServerId *string `type:"string"`

	// This property describes the condition of the SFTP server for the server that
	// was described. A value of ONLINE> indicates that the server can accept jobs
	// and transfer files. A State value of OFFLINE means that the server cannot
	// perform file transfer operations.
	//
	// The states of STARTING and STOPPING indicated that the server is in an intermediate
	// state, either not fully able to respond, or not fully offline. The values
	// of START_FAILED or STOP_FAILED can indicate an error condition.
	State *string `type:"string" enum:"State"`

	// This property is a numeric value that indicates the number of users that
	// are assigned to the SFTP server you specified with the ServerId.
	UserCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ListedServer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedServer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedServer) SetArn(v string) *ListedServer {
	s.Arn = &v
	return s
}

// SetIdentityProviderType sets the IdentityProviderType field's value.
func (s *ListedServer) SetIdentityProviderType(v string) *ListedServer {
	s.IdentityProviderType = &v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *ListedServer) SetLoggingRole(v string) *ListedServer {
	s.LoggingRole = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *ListedServer) SetServerId(v string) *ListedServer {
	s.ServerId = &v
	return s
}

// SetState sets the State field's value.
func (s *ListedServer) SetState(v string) *ListedServer {
	s.State = &v
	return s
}

// SetUserCount sets the UserCount field's value.
func (s *ListedServer) SetUserCount(v int64) *ListedServer {
	s.UserCount = &v
	return s
}

// Returns properties of the user that you specify.
type ListedUser struct {
	_ struct{} `type:"structure"`

	// This property is the unique Amazon Resource Name (ARN) for the user that
	// you wish to learn about.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// This value specifies the location that files are written to or read from
	// an Amazon S3 bucket for the user you specify by their ARN.
	HomeDirectory *string `type:"string"`

	// The role in use by this user. A role is an AWS Identity and Access Management
	// (IAM) entity that in this case allows the SFTP server to act on a user's
	// behalf. It allows the server to inherit the trust relationship that enables
	// that user to perform file operations to their Amazon S3 bucket.
	Role *string `type:"string"`

	// This value is the number of SSH public keys stored for the user you specified.
	SshPublicKeyCount *int64 `type:"integer"`

	// The name of the user whose ARN was specified. User names are used for authentication
	// purposes.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s ListedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedUser) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListedUser) SetArn(v string) *ListedUser {
	s.Arn = &v
	return s
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *ListedUser) SetHomeDirectory(v string) *ListedUser {
	s.HomeDirectory = &v
	return s
}

// SetRole sets the Role field's value.
func (s *ListedUser) SetRole(v string) *ListedUser {
	s.Role = &v
	return s
}

// SetSshPublicKeyCount sets the SshPublicKeyCount field's value.
func (s *ListedUser) SetSshPublicKeyCount(v int64) *ListedUser {
	s.SshPublicKeyCount = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListedUser) SetUserName(v string) *ListedUser {
	s.UserName = &v
	return s
}

// Provides information about the public Secure Shell (SSH) key that is associated
// with a user account for a specific server (as identified by ServerId). The
// information returned includes the date the key was imported, the public key
// contents, and the public key ID. A user can store more than one SSH public
// key associated with their user name on a specific SFTP server.
type SshPublicKey struct {
	_ struct{} `type:"structure"`

	// The date that the public key was added to the user account.
	//
	// DateImported is a required field
	DateImported *time.Time `type:"timestamp" required:"true"`

	// The content of the SSH public key as specified by the PublicKeyId.
	//
	// SshPublicKeyBody is a required field
	SshPublicKeyBody *string `type:"string" required:"true"`

	// The SshPublicKeyId parameter contains the identifier of the public key.
	//
	// SshPublicKeyId is a required field
	SshPublicKeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SshPublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SshPublicKey) GoString() string {
	return s.String()
}

// SetDateImported sets the DateImported field's value.
func (s *SshPublicKey) SetDateImported(v time.Time) *SshPublicKey {
	s.DateImported = &v
	return s
}

// SetSshPublicKeyBody sets the SshPublicKeyBody field's value.
func (s *SshPublicKey) SetSshPublicKeyBody(v string) *SshPublicKey {
	s.SshPublicKeyBody = &v
	return s
}

// SetSshPublicKeyId sets the SshPublicKeyId field's value.
func (s *SshPublicKey) SetSshPublicKeyId(v string) *SshPublicKey {
	s.SshPublicKeyId = &v
	return s
}

type StartServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that you start.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StartServerInput) SetServerId(v string) *StartServerInput {
	s.ServerId = &v
	return s
}

type StartServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartServerOutput) GoString() string {
	return s.String()
}

type StopServerInput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that you stopped.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *StopServerInput) SetServerId(v string) *StopServerInput {
	s.ServerId = &v
	return s
}

type StopServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopServerOutput) GoString() string {
	return s.String()
}

// Creates a key-value pair for a specific resource. Tags are metadata that
// you can use to search for and group a resource for various purposes. You
// can apply tags to servers, users, and roles. A tag key can take more than
// one value. For example, to group servers for accounting purposes, you might
// create a tag called Group and assign the values Research and Accounting to
// that group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name assigned to the tag that you create.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// This property contains one or more values that you assigned to the key name
	// you create.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) for a specific AWS resource, such as a server,
	// user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// Key-value pairs assigned to ARNs that you can use to group and search for
	// resources by type. You can attach this metadata to user accounts for any
	// purpose.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagResourceInput) SetArn(v string) *TagResourceInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TestIdentityProviderInput struct {
	_ struct{} `type:"structure"`

	// A system assigned identifier for a specific server. That server's user authentication
	// method is tested with a user name and password.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// This request parameter is name of the user account to be tested.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`

	// The password of the user account to be tested.
	UserPassword *string `type:"string"`
}

// String returns the string representation
func (s TestIdentityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestIdentityProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestIdentityProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestIdentityProviderInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerId sets the ServerId field's value.
func (s *TestIdentityProviderInput) SetServerId(v string) *TestIdentityProviderInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *TestIdentityProviderInput) SetUserName(v string) *TestIdentityProviderInput {
	s.UserName = &v
	return s
}

// SetUserPassword sets the UserPassword field's value.
func (s *TestIdentityProviderInput) SetUserPassword(v string) *TestIdentityProviderInput {
	s.UserPassword = &v
	return s
}

type TestIdentityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The result of the authorization test as a message.
	Message *string `type:"string"`

	// The HTTP status code that is the response from your API Gateway.
	//
	// StatusCode is a required field
	StatusCode *int64 `type:"integer" required:"true"`

	// The endpoint of the service used to authenticate a user.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestIdentityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestIdentityProviderOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TestIdentityProviderOutput) SetMessage(v string) *TestIdentityProviderOutput {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *TestIdentityProviderOutput) SetStatusCode(v int64) *TestIdentityProviderOutput {
	s.StatusCode = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *TestIdentityProviderOutput) SetUrl(v string) *TestIdentityProviderOutput {
	s.Url = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// This is the value of the resource that will have the tag removed. An Amazon
	// Resource Name (ARN) is an identifier for a specific AWS resource, such as
	// a server, user, or role.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// TagKeys are key-value pairs assigned to ARNs that can be used to group and
	// search for resources by type. This metadata can be attached to resources
	// for any purpose.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagResourceInput) SetArn(v string) *UntagResourceInput {
	s.Arn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// This response parameter is an array containing all of the information required
	// to call a customer's authentication API method.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Changes the AWS Identity and Access Management (IAM) role that allows Amazon
	// S3 events to be logged in Amazon CloudWatch, turning logging on or off.
	LoggingRole *string `type:"string"`

	// A system-assigned unique identifier for an SFTP server instance that the
	// user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityProviderDetails sets the IdentityProviderDetails field's value.
func (s *UpdateServerInput) SetIdentityProviderDetails(v *IdentityProviderDetails) *UpdateServerInput {
	s.IdentityProviderDetails = v
	return s
}

// SetLoggingRole sets the LoggingRole field's value.
func (s *UpdateServerInput) SetLoggingRole(v string) *UpdateServerInput {
	s.LoggingRole = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerInput) SetServerId(v string) *UpdateServerInput {
	s.ServerId = &v
	return s
}

type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server that the user account
	// is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateServerOutput) SetServerId(v string) *UpdateServerOutput {
	s.ServerId = &v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The HomeDirectory parameter specifies the landing directory (folder) for
	// a user when they log in to the server using their client. An example would
	// be: /home/username.
	HomeDirectory *string `type:"string"`

	// Allows you to supply a scope-down policy for your user so you can use the
	// same AWS Identity and Access Management (IAM) role across multiple users.
	// The policy scopes down users access to portions of your Amazon S3 bucket.
	// Variables you can use inside this policy include ${Transfer:UserName}, ${Transfer:HomeDirectory},
	// and ${Transfer:HomeBucket}.
	Policy *string `type:"string"`

	// The IAM role that controls your user’s access to your Amazon S3 bucket. The
	// policies attached to this role will determine the level of access you want
	// to provide your users when transferring files into and out of your Amazon
	// S3 bucket or buckets. The IAM role should also contain a trust relationship
	// that allows the Secure File Transfer Protocol (SFTP) server to access your
	// resources when servicing your SFTP user’s transfer requests.
	Role *string `type:"string"`

	// A system-assigned unique identifier for an SFTP server instance that the
	// user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// A unique string that identifies a user and is associated with a server as
	// specified by the ServerId. This is the string that will be used by your user
	// when they log in to your SFTP server.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.ServerId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHomeDirectory sets the HomeDirectory field's value.
func (s *UpdateUserInput) SetHomeDirectory(v string) *UpdateUserInput {
	s.HomeDirectory = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateUserInput) SetPolicy(v string) *UpdateUserInput {
	s.Policy = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateUserInput) SetRole(v string) *UpdateUserInput {
	s.Role = &v
	return s
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserInput) SetServerId(v string) *UpdateUserInput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

// UpdateUserResponse returns the user name and server identifier for the request
// to update a user's properties.
type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// A system-assigned unique identifier for an SFTP server instance that the
	// user account is assigned to.
	//
	// ServerId is a required field
	ServerId *string `type:"string" required:"true"`

	// The unique identifier for a user that is assigned to the SFTP server instance
	// that was specified in the request.
	//
	// UserName is a required field
	UserName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetServerId sets the ServerId field's value.
func (s *UpdateUserOutput) SetServerId(v string) *UpdateUserOutput {
	s.ServerId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserOutput) SetUserName(v string) *UpdateUserOutput {
	s.UserName = &v
	return s
}

// Returns information related to the type of user authentication that is in
// use for a server's users. For SERVICE_MANAGED authentication, the Secure
// Shell (SSH) public keys are stored with a user on an SFTP server instance.
// For API_GATEWAY authentication, your custom authentication method is implemented
// by using an API call. A server can only have one method of authentication.
const (
	// IdentityProviderTypeServiceManaged is a IdentityProviderType enum value
	IdentityProviderTypeServiceManaged = "SERVICE_MANAGED"

	// IdentityProviderTypeApiGateway is a IdentityProviderType enum value
	IdentityProviderTypeApiGateway = "API_GATEWAY"
)

// Describes the condition of the SFTP server with respect to its ability to
// perform file operations. There are six possible states: OFFLINE, ONLINE,
// STARTING, STOPPING, START_FAILED, and STOP_FAILED.
//
// OFFLINE indicates that the SFTP server exists, but that it is not available
// for file operations. ONLINE indicates that the SFTP server is available to
// perform file operations. STARTING indicates that the SFTP server's was instantiated,
// but the server is not yet available to perform file operations. Under normal
// conditions, it can take a couple of minutes for an SFTP server to be completely
// operational. Both START_FAILED and STOP_FAILED are error conditions.
const (
	// StateOffline is a State enum value
	StateOffline = "OFFLINE"

	// StateOnline is a State enum value
	StateOnline = "ONLINE"

	// StateStarting is a State enum value
	StateStarting = "STARTING"

	// StateStopping is a State enum value
	StateStopping = "STOPPING"

	// StateStartFailed is a State enum value
	StateStartFailed = "START_FAILED"

	// StateStopFailed is a State enum value
	StateStopFailed = "STOP_FAILED"
)
