---
title: v1.0.0-alpha.2
weight: 999000000
---

## Use new logging flags when running the Ansible and Helm operators

The Ansible and Helm operators now use controller-runtime's zap package
to define logging flags.

The `--zap-sample` and `--zap-time-encoding` flag have been removed since
they are not present in controller-runtime's flagset. These flags are no
longer supported.

The `--zap-level` flag is called `--zap-log-level` now. Rename any usage of
`--zap-level` to `--zap-log-level`

_See [#3596](https://github.com/operator-framework/operator-sdk/pull/3596) for more details._

## Core Ansible and Helm operator logic moved to `run` subcommand

If you are using the `ansible-operator` and `helm-operator` binaries
directly, update your usage to call `ansible-operator run` and
`helm-operator run` (e.g. in your Makefile's `make run` target).

If you are using the base image and you are not overriding the operator
entrypoint, no change is necessary because the base image has been updated
to call the `run` subcommand by default.

_See [#3596](https://github.com/operator-framework/operator-sdk/pull/3596) for more details._

## Rename `--update-crds` flag to `--update-objects` in `generate packagemanifests` invocations

This flag has been renamed to account for all objects that can be written to the package directory, ex. Roles.

_See [#3610](https://github.com/operator-framework/operator-sdk/pull/3610) for more details._

## Update scorecard API Go import paths

The scorecard v1alpha3 API has been moved to a separate repo. Update your Go import paths: From: `github.com/operator-framework/operator-framework/pkg/apis/scorecard/v1alpha3` To:   `github.com/operator-framework/api/pkg/apis/scorecard/v1alpha3`

_See [#3622](https://github.com/operator-framework/operator-sdk/pull/3622) for more details._

## Package `version` is no longer public

It is no longer possible to import package `version`. To
determine the version of operator-sdk, run `operator-sdk version`.

_See [#3617](https://github.com/operator-framework/operator-sdk/pull/3617) for more details._

## Remove `--operator-name` from scripts

The `--operator-name` flag has been removed from `generate bundle` and `generate packagemanifests` subcommands. Remove this flag from your scripts, and make sure the `project-name` key is set in your PROJECT file. If this key is not set, the current working directory's base name will be used.

_See [#3530](https://github.com/operator-framework/operator-sdk/pull/3530) for more details._

## Create resources manually that were passed to `run packagemanifests --include-paths`

The `run packagemanifests` subcommand no longer has the `--include-paths` flag to create additional resources. Instead, use `kubectl apply -f <paths>` before invoking `run packagemanifests`.

_See [#3599](https://github.com/operator-framework/operator-sdk/pull/3599) for more details._

## Change the `run packagemanifests` flag `--operator-version` to `--version`

`--operator-version` is now `--version`.

_See [#3599](https://github.com/operator-framework/operator-sdk/pull/3599) for more details._

## Remove `--olm-namespace` from `run packagemanifests` invocations

OLM namespace is no longer required by this command.

_See [#3601](https://github.com/operator-framework/operator-sdk/pull/3601) for more details._

## Change the `run packagemanifests` flag `--operator-namespace` to `--namespace`

`--operator-namespace` is now `--namespace`.

_See [#3601](https://github.com/operator-framework/operator-sdk/pull/3601) for more details._
