# Building

Please have a look at the Red Hat Productization [docs for building 3scale]
(https://docs.engineering.redhat.com/display/JP/3scale-AMP+Build+and+Release+Process).

Makefile targets you might find useful:

* `update-base-image`: to update the Dockerfiles' base image
* `new-sources`: for pointing the process to a specific repo and SHA for sources
* `vendor-sources`: for creating the tarball with the sources
* `sources`: for creating _and_ uploading the tarball with the sources

# Creating the release Docker image

Make sure you have all your changes committed and pushed, included whatever updates
to the vendored tarball.

1. Run `make build smoke`.

2. If everything is ok, you can go for `make test`.

3. Download (pull) the new image (BREW will output this in the web interface).

4. Run `make SMOKE_IMAGE=local:image smoke`.

5. Make sure you are on the release branch with all changes pushed and run `make brew`.
