// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/tracespan/tracespan_handler_service.proto

/*
	Package tracespan is a generated protocol buffer package.

	The `tracespan` template represents an individual span within a distributed trace.

	Example config:

	```yaml
	apiVersion: "config.istio.io/v1alpha2"
	kind: tracespan
	metadata:
	  name: default
	  namespace: istio-system
	spec:
	  traceId: request.headers["x-b3-traceid"]
	  spanId: request.headers["x-b3-spanid"] | ""
	  parentSpanId: request.headers["x-b3-parentspanid"] | ""
	  spanName: request.path | "/"
	  startTime: request.time
	  endTime: response.time
	  clientSpan: (context.reporter.kind | "inbound") == "inbound"
	  rewriteClientSpanId: false
	  spanTags:
	    http.method: request.method | ""
	    http.status_code: response.code | 200
	    http.url: request.path | ""
	    request.size: request.size | 0
	    response.size: response.size | 0
	    source.principal: source.principal | ""
	    source.version: source.labels["version"] | ""
	```

	See also: [Distributed Tracing](https://istio.io/docs/tasks/telemetry/distributed-tracing/)
	for information on tracing within Istio.

	TraceSpan represents an individual span within a distributed trace.

	When writing the configuration, the value for the fields associated with this template can either be a
	literal or an [expression](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/). Please note that if the datatype of a field is not istio.policy.v1beta1.Value,
	then the expression's [inferred type](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/#type-checking) must match the datatype of the field.

	It is generated from these files:
		mixer/template/tracespan/tracespan_handler_service.proto

	It has these top-level messages:
		HandleTraceSpanRequest
		InstanceMsg
		Type
		InstanceParam
*/
package tracespan

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"
import istio_policy_v1beta11 "istio.io/api/policy/v1beta1"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleTraceSpan method.
type HandleTraceSpanRequest struct {
	// 'tracespan' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleTraceSpanRequest) Reset()      { *m = HandleTraceSpanRequest{} }
func (*HandleTraceSpanRequest) ProtoMessage() {}
func (*HandleTraceSpanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{0}
}

// Contains instance payload for 'tracespan' template. This is passed to infrastructure backends during request-time
// through HandleTraceSpanService.HandleTraceSpan.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]*istio_policy_v1beta1.Value `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// HTTP status code used to set the span status. If unset or set to 0, the
	// span status will be assumed to be successful.
	HttpStatusCode int64 `protobuf:"varint,8,opt,name=httpStatusCode,proto3" json:"httpStatusCode,omitempty"`
	// client_span indicates the span kind. True for client spans and False or
	// not provided for server spans. Using bool instead of enum is a temporary
	// work around since mixer expression language does not yet support enum
	// type.
	//
	// Optional
	ClientSpan bool `protobuf:"varint,9,opt,name=client_span,json=clientSpan,proto3" json:"client_span,omitempty"`
	// rewrite_client_span_id is used to indicate whether to create a new client
	// span id to accommodate Zipkin shared span model. Some tracing systems like
	// Stackdriver separates a RPC into client span and server span. To solve this
	// incompatibility, deterministically rewriting both span id of client span and
	// parent span id of server span to the same newly generated id.
	//
	// Optional
	RewriteClientSpanId bool `protobuf:"varint,10,opt,name=rewrite_client_span_id,json=rewriteClientSpanId,proto3" json:"rewrite_client_span_id,omitempty"`
	// Identifies the source (client side) of this span.
	// Should usually be set to `source.workload.name`.
	//
	// Optional.
	SourceName string `protobuf:"bytes,11,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	// Client IP address. Should usually be set to `source.ip`.
	//
	// Optional.
	SourceIp *istio_policy_v1beta1.IPAddress `protobuf:"bytes,12,opt,name=source_ip,json=sourceIp" json:"source_ip,omitempty"`
	// Identifies the destination (server side) of this span.
	// Should usually be set to `destination.workload.name`.
	//
	// Optional.
	DestinationName string `protobuf:"bytes,13,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Server IP address. Should usually be set to `destination.ip`.
	//
	// Optional.
	DestinationIp *istio_policy_v1beta1.IPAddress `protobuf:"bytes,14,opt,name=destination_ip,json=destinationIp" json:"destination_ip,omitempty"`
	// Request body size. Should usually be set to `request.size`.
	//
	// Optional.
	RequestSize int64 `protobuf:"varint,15,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// Total request size (headers and body).
	// Should usually be set to `request.total_size`.
	//
	// Optional.
	RequestTotalSize int64 `protobuf:"varint,16,opt,name=request_total_size,json=requestTotalSize,proto3" json:"request_total_size,omitempty"`
	// Response body size. Should usually be set to `response.size`.
	//
	// Optional.
	ResponseSize int64 `protobuf:"varint,17,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Response total size (headers and body).
	// Should usually be set to `response.total_size`.
	//
	// Optional.
	ResponseTotalSize int64 `protobuf:"varint,18,opt,name=response_total_size,json=responseTotalSize,proto3" json:"response_total_size,omitempty"`
	// One of "http", "https", or "grpc" or any other value of
	// the `api.protocol` attribute. Should usually be set to `api.protocol`.
	//
	// Optional.
	ApiProtocol string `protobuf:"bytes,19,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'tracespan' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]istio_policy_v1beta11.ValueType `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTracespanHandlerService, []int{2} }

// Represents instance configuration schema for 'tracespan' template.
type InstanceParam struct {
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime string `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime string `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]string `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP status code used to set the span status. If unset or set to 0, the
	// span status will be assumed to be successful.
	HttpStatusCode string `protobuf:"bytes,8,opt,name=httpStatusCode,proto3" json:"httpStatusCode,omitempty"`
	// client_span indicates the span kind. True for client spans and False or
	// not provided for server spans. Using bool instead of enum is a temporary
	// work around since mixer expression language does not yet support enum
	// type.
	//
	// Optional
	ClientSpan string `protobuf:"bytes,9,opt,name=client_span,json=clientSpan,proto3" json:"client_span,omitempty"`
	// rewrite_client_span_id is used to indicate whether to create a new client
	// span id to accommodate Zipkin shared span model. Some tracing systems like
	// Stackdriver separates a RPC into client span and server span. To solve this
	// incompatibility, deterministically rewriting both span id of client span and
	// parent span id of server span to the same newly generated id.
	//
	// Optional
	RewriteClientSpanId string `protobuf:"bytes,10,opt,name=rewrite_client_span_id,json=rewriteClientSpanId,proto3" json:"rewrite_client_span_id,omitempty"`
	// Identifies the source (client side) of this span.
	// Should usually be set to `source.workload.name`.
	//
	// Optional.
	SourceName string `protobuf:"bytes,11,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	// Client IP address. Should usually be set to `source.ip`.
	//
	// Optional.
	SourceIp string `protobuf:"bytes,12,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Identifies the destination (server side) of this span.
	// Should usually be set to `destination.workload.name`.
	//
	// Optional.
	DestinationName string `protobuf:"bytes,13,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Server IP address. Should usually be set to `destination.ip`.
	//
	// Optional.
	DestinationIp string `protobuf:"bytes,14,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Request body size. Should usually be set to `request.size`.
	//
	// Optional.
	RequestSize string `protobuf:"bytes,15,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// Total request size (headers and body).
	// Should usually be set to `request.total_size`.
	//
	// Optional.
	RequestTotalSize string `protobuf:"bytes,16,opt,name=request_total_size,json=requestTotalSize,proto3" json:"request_total_size,omitempty"`
	// Response body size. Should usually be set to `response.size`.
	//
	// Optional.
	ResponseSize string `protobuf:"bytes,17,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Response total size (headers and body).
	// Should usually be set to `response.total_size`.
	//
	// Optional.
	ResponseTotalSize string `protobuf:"bytes,18,opt,name=response_total_size,json=responseTotalSize,proto3" json:"response_total_size,omitempty"`
	// One of "http", "https", or "grpc" or any other value of
	// the `api.protocol` attribute. Should usually be set to `api.protocol`.
	//
	// Optional.
	ApiProtocol string `protobuf:"bytes,19,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleTraceSpanRequest)(nil), "tracespan.HandleTraceSpanRequest")
	proto.RegisterType((*InstanceMsg)(nil), "tracespan.InstanceMsg")
	proto.RegisterType((*Type)(nil), "tracespan.Type")
	proto.RegisterType((*InstanceParam)(nil), "tracespan.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleTraceSpanService service

type HandleTraceSpanServiceClient interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleTraceSpanServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleTraceSpanServiceClient(cc *grpc.ClientConn) HandleTraceSpanServiceClient {
	return &handleTraceSpanServiceClient{cc}
}

func (c *handleTraceSpanServiceClient) HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/tracespan.HandleTraceSpanService/HandleTraceSpan", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleTraceSpanService service

type HandleTraceSpanServiceServer interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(context.Context, *HandleTraceSpanRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleTraceSpanServiceServer(s *grpc.Server, srv HandleTraceSpanServiceServer) {
	s.RegisterService(&_HandleTraceSpanService_serviceDesc, srv)
}

func _HandleTraceSpanService_HandleTraceSpan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleTraceSpanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tracespan.HandleTraceSpanService/HandleTraceSpan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, req.(*HandleTraceSpanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleTraceSpanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tracespan.HandleTraceSpanService",
	HandlerType: (*HandleTraceSpanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleTraceSpan",
			Handler:    _HandleTraceSpanService_HandleTraceSpan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/tracespan/tracespan_handler_service.proto",
}

func (m *HandleTraceSpanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleTraceSpanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if m.StartTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.StartTime.Size()))
		n2, err := m.StartTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.EndTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.EndTime.Size()))
		n3, err := m.EndTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTracespanHandlerService(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + msgSize
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v.Size()))
				n4, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n4
			}
		}
	}
	if m.HttpStatusCode != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.HttpStatusCode))
	}
	if m.ClientSpan {
		dAtA[i] = 0x48
		i++
		if m.ClientSpan {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RewriteClientSpanId {
		dAtA[i] = 0x50
		i++
		if m.RewriteClientSpanId {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SourceName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceName)))
		i += copy(dAtA[i:], m.SourceName)
	}
	if m.SourceIp != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.SourceIp.Size()))
		n5, err := m.SourceIp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.DestinationName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationName)))
		i += copy(dAtA[i:], m.DestinationName)
	}
	if m.DestinationIp != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.DestinationIp.Size()))
		n6, err := m.DestinationIp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.RequestSize != 0 {
		dAtA[i] = 0x78
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.RequestSize))
	}
	if m.RequestTotalSize != 0 {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.RequestTotalSize))
	}
	if m.ResponseSize != 0 {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.ResponseSize))
	}
	if m.ResponseTotalSize != 0 {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.ResponseTotalSize))
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if len(m.StartTime) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.StartTime)))
		i += copy(dAtA[i:], m.StartTime)
	}
	if len(m.EndTime) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.EndTime)))
		i += copy(dAtA[i:], m.EndTime)
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.HttpStatusCode) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.HttpStatusCode)))
		i += copy(dAtA[i:], m.HttpStatusCode)
	}
	if len(m.ClientSpan) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ClientSpan)))
		i += copy(dAtA[i:], m.ClientSpan)
	}
	if len(m.RewriteClientSpanId) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RewriteClientSpanId)))
		i += copy(dAtA[i:], m.RewriteClientSpanId)
	}
	if len(m.SourceName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceName)))
		i += copy(dAtA[i:], m.SourceName)
	}
	if len(m.SourceIp) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceIp)))
		i += copy(dAtA[i:], m.SourceIp)
	}
	if len(m.DestinationName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationName)))
		i += copy(dAtA[i:], m.DestinationName)
	}
	if len(m.DestinationIp) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationIp)))
		i += copy(dAtA[i:], m.DestinationIp)
	}
	if len(m.RequestSize) > 0 {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RequestSize)))
		i += copy(dAtA[i:], m.RequestSize)
	}
	if len(m.RequestTotalSize) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RequestTotalSize)))
		i += copy(dAtA[i:], m.RequestTotalSize)
	}
	if len(m.ResponseSize) > 0 {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ResponseSize)))
		i += copy(dAtA[i:], m.ResponseSize)
	}
	if len(m.ResponseTotalSize) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ResponseTotalSize)))
		i += copy(dAtA[i:], m.ResponseTotalSize)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	return i, nil
}

func encodeVarintTracespanHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleTraceSpanRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTracespanHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.EndTime != nil {
		l = m.EndTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTracespanHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	if m.HttpStatusCode != 0 {
		n += 1 + sovTracespanHandlerService(uint64(m.HttpStatusCode))
	}
	if m.ClientSpan {
		n += 2
	}
	if m.RewriteClientSpanId {
		n += 2
	}
	l = len(m.SourceName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.SourceIp != nil {
		l = m.SourceIp.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.DestinationIp != nil {
		l = m.DestinationIp.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.RequestSize != 0 {
		n += 1 + sovTracespanHandlerService(uint64(m.RequestSize))
	}
	if m.RequestTotalSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.RequestTotalSize))
	}
	if m.ResponseSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.ResponseSize))
	}
	if m.ResponseTotalSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.ResponseTotalSize))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.StartTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.EndTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.HttpStatusCode)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ClientSpan)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RewriteClientSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SourceName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SourceIp)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationIp)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RequestSize)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RequestTotalSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ResponseSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ResponseTotalSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func sovTracespanHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTracespanHandlerService(x uint64) (n int) {
	return sovTracespanHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleTraceSpanRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleTraceSpanRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]*istio_policy_v1beta1.Value{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`EndTime:` + strings.Replace(fmt.Sprintf("%v", this.EndTime), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`HttpStatusCode:` + fmt.Sprintf("%v", this.HttpStatusCode) + `,`,
		`ClientSpan:` + fmt.Sprintf("%v", this.ClientSpan) + `,`,
		`RewriteClientSpanId:` + fmt.Sprintf("%v", this.RewriteClientSpanId) + `,`,
		`SourceName:` + fmt.Sprintf("%v", this.SourceName) + `,`,
		`SourceIp:` + strings.Replace(fmt.Sprintf("%v", this.SourceIp), "IPAddress", "istio_policy_v1beta1.IPAddress", 1) + `,`,
		`DestinationName:` + fmt.Sprintf("%v", this.DestinationName) + `,`,
		`DestinationIp:` + strings.Replace(fmt.Sprintf("%v", this.DestinationIp), "IPAddress", "istio_policy_v1beta1.IPAddress", 1) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`RequestTotalSize:` + fmt.Sprintf("%v", this.RequestTotalSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`ResponseTotalSize:` + fmt.Sprintf("%v", this.ResponseTotalSize) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]istio_policy_v1beta11.ValueType{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&Type{`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]string{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + fmt.Sprintf("%v", this.StartTime) + `,`,
		`EndTime:` + fmt.Sprintf("%v", this.EndTime) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`HttpStatusCode:` + fmt.Sprintf("%v", this.HttpStatusCode) + `,`,
		`ClientSpan:` + fmt.Sprintf("%v", this.ClientSpan) + `,`,
		`RewriteClientSpanId:` + fmt.Sprintf("%v", this.RewriteClientSpanId) + `,`,
		`SourceName:` + fmt.Sprintf("%v", this.SourceName) + `,`,
		`SourceIp:` + fmt.Sprintf("%v", this.SourceIp) + `,`,
		`DestinationName:` + fmt.Sprintf("%v", this.DestinationName) + `,`,
		`DestinationIp:` + fmt.Sprintf("%v", this.DestinationIp) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`RequestTotalSize:` + fmt.Sprintf("%v", this.RequestTotalSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`ResponseTotalSize:` + fmt.Sprintf("%v", this.ResponseTotalSize) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTracespanHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleTraceSpanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTime == nil {
				m.EndTime = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]*istio_policy_v1beta1.Value)
			}
			var mapkey string
			var mapvalue *istio_policy_v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &istio_policy_v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpStatusCode", wireType)
			}
			m.HttpStatusCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HttpStatusCode |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSpan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClientSpan = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RewriteClientSpanId", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RewriteClientSpanId = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceIp == nil {
				m.SourceIp = &istio_policy_v1beta1.IPAddress{}
			}
			if err := m.SourceIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationIp == nil {
				m.DestinationIp = &istio_policy_v1beta1.IPAddress{}
			}
			if err := m.DestinationIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			m.RequestSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTotalSize", wireType)
			}
			m.RequestTotalSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestTotalSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			m.ResponseSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTotalSize", wireType)
			}
			m.ResponseTotalSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseTotalSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]istio_policy_v1beta11.ValueType)
			}
			var mapkey string
			var mapvalue istio_policy_v1beta11.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_policy_v1beta11.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpStatusCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpStatusCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSpan", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientSpan = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RewriteClientSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RewriteClientSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTotalSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestTotalSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTotalSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseTotalSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTracespanHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTracespanHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTracespanHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTracespanHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTracespanHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/template/tracespan/tracespan_handler_service.proto", fileDescriptorTracespanHandlerService)
}

var fileDescriptorTracespanHandlerService = []byte{
	// 983 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xf7, 0x26, 0x6d, 0xe2, 0x19, 0xc7, 0x4e, 0x3a, 0x09, 0x61, 0xe3, 0xa8, 0x1b, 0x27, 0x94,
	0xca, 0x48, 0xd5, 0x5a, 0x49, 0x41, 0xaa, 0x5a, 0x84, 0x14, 0xa2, 0x22, 0x7c, 0x00, 0x45, 0x6b,
	0x0b, 0x71, 0x40, 0x5a, 0x4d, 0xbc, 0xaf, 0xee, 0x88, 0xf5, 0xee, 0xb0, 0x33, 0x0e, 0x75, 0x2f,
	0x20, 0x3e, 0x01, 0x52, 0x4f, 0xdc, 0x38, 0x21, 0x6e, 0x7c, 0x01, 0x3e, 0x40, 0x85, 0x84, 0x54,
	0x71, 0xe2, 0x82, 0x44, 0x4c, 0x0f, 0x1c, 0x7b, 0xe4, 0x88, 0xf6, 0xcd, 0xda, 0x5e, 0x1c, 0xb7,
	0x75, 0x73, 0xe1, 0x36, 0xf3, 0xde, 0x6f, 0xe6, 0xfd, 0x99, 0xf9, 0xfd, 0xf4, 0xe8, 0xad, 0x9e,
	0x78, 0x00, 0x49, 0x43, 0x43, 0x4f, 0x86, 0x5c, 0x43, 0x43, 0x27, 0xbc, 0x03, 0x4a, 0xf2, 0x68,
	0xb2, 0xf2, 0xef, 0xf3, 0x28, 0x08, 0x21, 0xf1, 0x15, 0x24, 0xa7, 0xa2, 0x03, 0xae, 0x4c, 0x62,
	0x1d, 0x33, 0x32, 0x06, 0x54, 0x37, 0xba, 0x71, 0x37, 0x46, 0x6b, 0x23, 0x5d, 0x19, 0x40, 0xf5,
	0x86, 0xb9, 0x9a, 0x07, 0x5c, 0x6a, 0x48, 0x1a, 0xbd, 0x38, 0x80, 0xb0, 0x71, 0xba, 0x7f, 0x02,
	0x9a, 0xef, 0x37, 0xe0, 0x81, 0x86, 0x48, 0x89, 0x38, 0x52, 0x19, 0x7a, 0xab, 0x1b, 0xc7, 0xdd,
	0x10, 0x1a, 0xb8, 0x3b, 0xe9, 0xdf, 0x6b, 0xf0, 0x68, 0x90, 0xb9, 0xea, 0x2f, 0xba, 0x28, 0x01,
	0x19, 0x27, 0x7a, 0x74, 0x89, 0x8c, 0x43, 0xd1, 0x19, 0x8c, 0x9d, 0x7a, 0x20, 0xb3, 0x74, 0xab,
	0x3b, 0x53, 0xae, 0x53, 0x1e, 0xf6, 0xc1, 0x9f, 0x00, 0xf6, 0x7e, 0xb0, 0xe8, 0xe6, 0x87, 0x58,
	0x69, 0x3b, 0x2d, 0xac, 0x25, 0x79, 0xe4, 0xc1, 0x17, 0x7d, 0x50, 0x9a, 0xbd, 0x4d, 0x89, 0x88,
	0x94, 0xe6, 0x51, 0x07, 0x94, 0x6d, 0xd5, 0x16, 0xeb, 0xa5, 0x83, 0x4d, 0x77, 0x5c, 0xbe, 0xdb,
	0xcc, 0x7c, 0x1f, 0xa9, 0xae, 0x37, 0x01, 0xb2, 0x3b, 0xb4, 0x92, 0xa5, 0xec, 0x77, 0xe2, 0xe8,
	0x9e, 0xe8, 0xda, 0x0b, 0x35, 0xab, 0x5e, 0x3a, 0xd8, 0x70, 0x4d, 0xa9, 0xee, 0xa8, 0x54, 0xf7,
	0x30, 0x1a, 0x78, 0xe5, 0x0c, 0x7b, 0x84, 0x50, 0xb6, 0x45, 0x8b, 0x01, 0x04, 0x7d, 0xe9, 0x8b,
	0xc0, 0x5e, 0xac, 0x59, 0x75, 0xe2, 0x2d, 0xe3, 0xbe, 0x19, 0xec, 0xfd, 0xba, 0x4c, 0x4b, 0xb9,
	0x90, 0x29, 0x14, 0x73, 0x49, 0xa1, 0x96, 0x81, 0xe2, 0xbe, 0x19, 0xb0, 0xd7, 0xe9, 0x32, 0xbe,
	0xa0, 0x08, 0x30, 0x36, 0xf1, 0x96, 0xd2, 0x6d, 0x33, 0x60, 0xd7, 0x68, 0x45, 0xf2, 0x04, 0x22,
	0xed, 0x8f, 0xfc, 0x26, 0xc8, 0x8a, 0xb1, 0xb6, 0x0c, 0x6a, 0x9b, 0x12, 0x74, 0x47, 0xbc, 0x07,
	0xf6, 0x25, 0x04, 0x14, 0x53, 0xc3, 0xc7, 0xbc, 0x07, 0xec, 0x3d, 0x4a, 0x95, 0xe6, 0x89, 0xf6,
	0xb5, 0xe8, 0x81, 0x7d, 0x19, 0x4b, 0xdb, 0x71, 0x85, 0xd2, 0x22, 0x76, 0x4d, 0xaf, 0xdd, 0xac,
	0xd7, 0x6e, 0x5b, 0xf4, 0xa0, 0xa5, 0x79, 0x4f, 0x7a, 0x04, 0x8f, 0xa4, 0x7b, 0x76, 0x9b, 0x16,
	0x21, 0x0a, 0xcc, 0xe9, 0xa5, 0xf9, 0x4e, 0x2f, 0x43, 0x14, 0xe0, 0xd9, 0xc3, 0x2c, 0x31, 0xcd,
	0xbb, 0xca, 0x5e, 0xc6, 0x07, 0xb9, 0x36, 0xfb, 0x41, 0xdc, 0xb4, 0x94, 0x36, 0xef, 0xaa, 0xbb,
	0x91, 0x4e, 0x06, 0x26, 0xfd, 0x74, 0xcb, 0xae, 0xd3, 0xca, 0x7d, 0xad, 0x65, 0x4b, 0x73, 0xdd,
	0x57, 0x47, 0x71, 0x00, 0x76, 0xb1, 0x66, 0xd5, 0x17, 0xbd, 0x29, 0x2b, 0xdb, 0xa1, 0xa5, 0x4e,
	0x28, 0x46, 0x9d, 0xb2, 0x49, 0xcd, 0xaa, 0x17, 0x3d, 0x6a, 0x4c, 0xe9, 0xdd, 0xec, 0x26, 0xdd,
	0x4c, 0xe0, 0xcb, 0x44, 0x68, 0xf0, 0x73, 0xc0, 0xb4, 0xa5, 0x14, 0xb1, 0xeb, 0x99, 0xf7, 0x68,
	0x7c, 0xa4, 0x19, 0xa4, 0xb7, 0xaa, 0xb8, 0x9f, 0x74, 0xc0, 0xf4, 0xb6, 0x84, 0xbd, 0xa5, 0xc6,
	0x84, 0xdd, 0x7d, 0x97, 0x92, 0x0c, 0x20, 0xa4, 0xbd, 0xf2, 0xa2, 0xf6, 0x34, 0x8f, 0x0f, 0x83,
	0x20, 0x01, 0xa5, 0xbc, 0xa2, 0x39, 0xd1, 0x94, 0xec, 0x2d, 0xba, 0x16, 0x80, 0xd2, 0x22, 0xe2,
	0x5a, 0xc4, 0xd9, 0xfb, 0x95, 0x31, 0xc6, 0x6a, 0xce, 0x8e, 0x81, 0x3e, 0xa0, 0x95, 0x3c, 0x54,
	0x48, 0xbb, 0x32, 0x5f, 0xb4, 0x72, 0xee, 0x58, 0x53, 0xb2, 0x5d, 0xba, 0x92, 0x18, 0xba, 0xf8,
	0x4a, 0x3c, 0x04, 0x7b, 0x15, 0xbb, 0x59, 0xca, 0x6c, 0x2d, 0xf1, 0x10, 0xd8, 0x0d, 0xca, 0x46,
	0x10, 0x1d, 0x6b, 0x1e, 0x1a, 0xe0, 0x1a, 0x02, 0xd7, 0x32, 0x4f, 0x3b, 0x75, 0x20, 0xfa, 0x0d,
	0x5a, 0x4e, 0x40, 0xc9, 0x38, 0x52, 0x60, 0x80, 0x57, 0x10, 0xb8, 0x32, 0x32, 0x22, 0xc8, 0xa5,
	0xeb, 0x63, 0x50, 0xee, 0x4e, 0x86, 0xd0, 0x2b, 0x23, 0xd7, 0xe4, 0xd2, 0x5d, 0xba, 0xc2, 0xa5,
	0xf0, 0x91, 0x79, 0x9d, 0x38, 0xb4, 0xd7, 0xb1, 0x29, 0x25, 0x2e, 0xc5, 0x71, 0x66, 0x62, 0xaf,
	0xd1, 0x4b, 0xd8, 0xaf, 0x9f, 0x7e, 0xf9, 0x79, 0x0f, 0xbd, 0xb8, 0xad, 0x7e, 0x4a, 0xcb, 0xff,
	0xf9, 0x4a, 0x6c, 0x8d, 0x2e, 0x7e, 0x0e, 0x83, 0x8c, 0x71, 0xe9, 0x92, 0xed, 0xd3, 0xcb, 0xa8,
	0x2a, 0x19, 0xcf, 0xb7, 0x67, 0x77, 0xf0, 0x93, 0x14, 0xe2, 0x19, 0xe4, 0xed, 0x85, 0x5b, 0xd6,
	0xde, 0xf7, 0x16, 0xbd, 0xd4, 0x1e, 0xc8, 0x94, 0x11, 0xe7, 0x7e, 0xf5, 0xd5, 0xdc, 0xaf, 0x4e,
	0x31, 0xcf, 0xfb, 0xce, 0xd5, 0xcf, 0x5e, 0x9e, 0xde, 0x3b, 0xf9, 0xf4, 0x2a, 0xcf, 0x7b, 0x60,
	0x4c, 0x2f, 0x0d, 0x95, 0x4f, 0xf1, 0xbb, 0x25, 0x5a, 0x1e, 0x91, 0xea, 0x98, 0x27, 0xbc, 0xf7,
	0x7f, 0x89, 0xce, 0xd5, 0x73, 0xa2, 0x43, 0xf2, 0x9a, 0xb2, 0x35, 0xa5, 0x29, 0x64, 0x22, 0x19,
	0x47, 0xe7, 0x9b, 0x7b, 0x7d, 0x86, 0x64, 0x60, 0x75, 0xaf, 0x28, 0x1a, 0x64, 0x1e, 0xd1, 0x20,
	0xaf, 0x20, 0x1a, 0xe4, 0x82, 0xa2, 0xb1, 0x3d, 0x2d, 0x1a, 0xe4, 0x62, 0x9a, 0xf0, 0xe6, 0x4c,
	0x4d, 0x20, 0xf3, 0x50, 0x9e, 0xcc, 0x4b, 0x79, 0x32, 0x2f, 0xe5, 0xc9, 0xfc, 0x94, 0x27, 0x17,
	0xa3, 0x7c, 0xf5, 0xce, 0xcb, 0xc9, 0xb3, 0x91, 0x27, 0x0f, 0xc9, 0x71, 0xe3, 0xe0, 0xab, 0x73,
	0x63, 0x43, 0xcb, 0xcc, 0x49, 0x0c, 0xe8, 0xea, 0x94, 0x87, 0xed, 0xe6, 0xbe, 0xdc, 0xec, 0x61,
	0xa3, 0xda, 0xc8, 0x78, 0x89, 0x43, 0x8f, 0x9b, 0x4d, 0x05, 0x2e, 0x0e, 0x3d, 0x63, 0x92, 0x7a,
	0x38, 0xf4, 0x78, 0xa0, 0xfa, 0xa1, 0x7e, 0xff, 0xee, 0xe3, 0x33, 0xa7, 0xf0, 0xe4, 0xcc, 0x29,
	0xfc, 0x7e, 0xe6, 0x14, 0x9e, 0x9d, 0x39, 0x85, 0xaf, 0x87, 0x8e, 0xf5, 0xe3, 0xd0, 0x29, 0x3c,
	0x1e, 0x3a, 0xd6, 0x93, 0xa1, 0x63, 0xfd, 0x39, 0x74, 0xac, 0xbf, 0x87, 0x4e, 0xe1, 0xd9, 0xd0,
	0xb1, 0xbe, 0xfd, 0xcb, 0x29, 0xfc, 0xf3, 0xdb, 0xd3, 0x47, 0x0b, 0xd6, 0x37, 0x7f, 0x3c, 0x7d,
	0xb4, 0x30, 0x19, 0xe2, 0x4e, 0x96, 0xb0, 0x43, 0x37, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0xbe,
	0xef, 0xf4, 0x04, 0x12, 0x0a, 0x00, 0x00,
}
