"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.babelLoader = void 0;

var _coreCommon = require("@storybook/core-common");

var _babelConfig = (0, _coreCommon.babelConfig)(),
    plugins = _babelConfig.plugins,
    presets = _babelConfig.presets;

var babelLoader = function () {
  return {
    test: /\.(mjs|tsx?|jsx?)$/,
    use: [{
      loader: require.resolve('babel-loader'),
      options: {
        sourceType: 'unambiguous',
        presets: [...presets, require.resolve('@babel/preset-react')],
        plugins: [...plugins, // Should only be done on manager. Template literals are not meant to be
        // transformed for frameworks like ember
        require.resolve('@babel/plugin-transform-template-literals')]
      }
    }],
    include: [(0, _coreCommon.getProjectRoot)()],
    exclude: [/node_modules/, /dist/]
  };
};

exports.babelLoader = babelLoader;