"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overridePresets = exports.corePresets = exports.build = exports.bail = exports.start = exports.makeStatsFromError = exports.executor = exports.getConfig = void 0;

var _webpack = _interopRequireWildcard(require("webpack"));

var _webpackDevMiddleware = _interopRequireDefault(require("webpack-dev-middleware"));

var _nodeLogger = require("@storybook/node-logger");

var _coreCommon = require("@storybook/core-common");

var _fsExtra = require("fs-extra");

var _express = _interopRequireDefault(require("express"));

var _managerConfig = require("./manager-config");

var _managerCache = require("../utils/manager-cache");

var _prebuiltManager = require("../utils/prebuilt-manager");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var compilation;
var reject;

var checkWebpackVersion4 = function (webpackInstance) {
  return (0, _coreCommon.checkWebpackVersion)(webpackInstance, '4.x', 'manager-builder');
};

var getConfig = _managerConfig.getManagerWebpackConfig;
exports.getConfig = getConfig;
var executor = {
  get: _webpack.default
};
exports.executor = executor;

var makeStatsFromError = function (err) {
  return {
    hasErrors: function () {
      return true;
    },
    hasWarnings: function () {
      return false;
    },
    toJson: function () {
      return {
        warnings: [],
        errors: [err]
      };
    }
  };
};

exports.makeStatsFromError = makeStatsFromError;

var start = async function ({
  startTime: startTime,
  options: options,
  router: router
}) {
  var _config$output;

  checkWebpackVersion4(executor.get);
  var prebuiltDir = await (0, _prebuiltManager.getPrebuiltDir)(options);
  var config = await getConfig(options);

  if (options.cache) {
    if (options.managerCache) {
      var _await$Promise$all = await Promise.all([// must run even if outputDir doesn't exist, otherwise the 2nd run won't use cache
      (0, _managerCache.useManagerCache)(options.cache, config), (0, _fsExtra.pathExists)(options.outputDir)]),
          _await$Promise$all2 = _slicedToArray(_await$Promise$all, 2),
          useCache = _await$Promise$all2[0],
          hasOutput = _await$Promise$all2[1];

      if (useCache && hasOutput && !options.smokeTest) {
        _nodeLogger.logger.info('=> Using cached manager'); // Manager static files


        router.use('/', _express.default.static(prebuiltDir || options.outputDir));
        return;
      }
    } else if (!options.smokeTest && (await (0, _managerCache.clearManagerCache)(options.cache))) {
      _nodeLogger.logger.info('=> Cleared cached manager config');
    }
  }

  var compiler = executor.get(config);

  if (!compiler) {
    var err = `${config.name}: missing webpack compiler at runtime!`;

    _nodeLogger.logger.error(err); // eslint-disable-next-line consistent-return


    return {
      bail: bail,
      totalTime: process.hrtime(startTime),
      stats: makeStatsFromError(err)
    };
  }

  var _await$useProgressRep = await (0, _coreCommon.useProgressReporting)(router, startTime, options),
      handler = _await$useProgressRep.handler,
      modulesCount = _await$useProgressRep.modulesCount;

  new _webpack.ProgressPlugin({
    handler: handler,
    modulesCount: modulesCount
  }).apply(compiler);
  var middlewareOptions = {
    publicPath: (_config$output = config.output) === null || _config$output === void 0 ? void 0 : _config$output.publicPath,
    writeToDisk: true
  };
  compilation = (0, _webpackDevMiddleware.default)(compiler, middlewareOptions);
  router.use(compilation);
  var stats = await new Promise(function (ready, stop) {
    compilation.waitUntilValid(ready);
    reject = stop;
  });

  if (!stats) {
    throw new Error('no stats after building preview');
  } // eslint-disable-next-line consistent-return


  return {
    bail: bail,
    stats: stats,
    totalTime: process.hrtime(startTime)
  };
};

exports.start = start;

var bail = function (e) {
  if (reject) {
    reject();
  }

  if (process) {
    try {
      compilation.close();

      _nodeLogger.logger.warn('Force closed preview build');
    } catch (err) {
      _nodeLogger.logger.warn('Unable to close preview build!');
    }
  }

  throw e;
};

exports.bail = bail;

var build = async function ({
  options: options,
  startTime: startTime
}) {
  _nodeLogger.logger.info('=> Compiling manager..');

  checkWebpackVersion4(executor.get);
  var config = await getConfig(options);
  var statsOptions = typeof config.stats === 'boolean' ? 'minimal' : config.stats;
  var compiler = executor.get(config);

  if (!compiler) {
    var err = `${config.name}: missing webpack compiler at runtime!`;

    _nodeLogger.logger.error(err);

    return Promise.resolve(makeStatsFromError(err));
  }

  return new Promise(function (succeed, fail) {
    compiler.run(function (error, stats) {
      if (error || !stats || stats.hasErrors()) {
        _nodeLogger.logger.error('=> Failed to build the manager');

        if (error) {
          _nodeLogger.logger.error(error.message);
        }

        if (stats && (stats.hasErrors() || stats.hasWarnings())) {
          var _stats$toJson = stats.toJson(statsOptions),
              warnings = _stats$toJson.warnings,
              errors = _stats$toJson.errors;

          errors.forEach(function (e) {
            return _nodeLogger.logger.error(e);
          });
          warnings.forEach(function (e) {
            return _nodeLogger.logger.error(e);
          });
        }

        process.exitCode = 1;
        fail(error || stats);
      } else {
        var _statsData$warnings;

        _nodeLogger.logger.trace({
          message: '=> Manager built',
          time: process.hrtime(startTime)
        });

        var statsData = stats.toJson(typeof statsOptions === 'string' ? statsOptions : _objectSpread(_objectSpread({}, statsOptions), {}, {
          warnings: true
        }));
        statsData === null || statsData === void 0 ? void 0 : (_statsData$warnings = statsData.warnings) === null || _statsData$warnings === void 0 ? void 0 : _statsData$warnings.forEach(function (e) {
          return _nodeLogger.logger.warn(e);
        });
        succeed(stats);
      }
    });
  });
};

exports.build = build;
var corePresets = [];
exports.corePresets = corePresets;
var overridePresets = [];
exports.overridePresets = overridePresets;