import chalk from 'chalk';
import { colors } from '@storybook/node-logger';
import boxen from 'boxen';
import dedent from 'ts-dedent';
import Table from 'cli-table3';
import prettyTime from 'pretty-hrtime';
import { createUpdateMessage } from './update-check';
export function outputStartupInformation(options) {
  var updateInfo = options.updateInfo,
      version = options.version,
      address = options.address,
      networkAddress = options.networkAddress,
      managerTotalTime = options.managerTotalTime,
      previewTotalTime = options.previewTotalTime;
  var updateMessage = createUpdateMessage(updateInfo, version);
  var serveMessage = new Table({
    chars: {
      top: '',
      'top-mid': '',
      'top-left': '',
      'top-right': '',
      bottom: '',
      'bottom-mid': '',
      'bottom-left': '',
      'bottom-right': '',
      left: '',
      'left-mid': '',
      mid: '',
      'mid-mid': '',
      right: '',
      'right-mid': '',
      middle: ''
    },
    // @ts-ignore
    paddingLeft: 0,
    paddingRight: 0,
    paddingTop: 0,
    paddingBottom: 0
  });
  serveMessage.push(['Local:', chalk.cyan(address)], ['On your network:', chalk.cyan(networkAddress)]);
  var timeStatement = [managerTotalTime && `${chalk.underline(prettyTime(managerTotalTime))} for manager`, previewTotalTime && `${chalk.underline(prettyTime(previewTotalTime))} for preview`].filter(Boolean).join(' and '); // eslint-disable-next-line no-console

  console.log(boxen(dedent`
          ${colors.green(`Storybook ${chalk.bold(version)} started`)}
          ${chalk.gray(timeStatement)}

          ${serveMessage.toString()}${updateMessage ? `\n\n${updateMessage}` : ''}
        `, {
    borderStyle: 'round',
    padding: 1,
    borderColor: '#F1618C'
  }));
}