"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var arrays_1 = require("./utils/arrays");
var units_1 = require("./units");
var delimited = function (delimiter) {
    return function () {
        return arrays_1.filter(arguments, function (s) { return s || s === 0; })
            .map(function (s) { return typeof s === 'number' ? units_1.px(s) : s.toString(); })
            .join(delimiter);
    };
};
exports.params = delimited(' ');
exports.list = delimited(',');
