"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var formatting_1 = require("./utils/formatting");
/**
 * The CSS transform property lets you modify the coordinate space of the CSS visual formatting model. Using it, elements can be translated, rotated, scaled, and skewed.
 * Returns the transforms as a delimited string by space or returns 'none' if no arguments are provided
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/transform
 */
function transform() {
    var transforms = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        transforms[_i] = arguments[_i];
    }
    return transforms.length ? transforms.join(' ') : 'none';
}
exports.transform = transform;
exports.matrix = formatting_1.createFunction('matrix');
exports.matrix3d = formatting_1.createFunction('matrix3d');
exports.perspective = formatting_1.createFunction('perspective');
exports.rotate = formatting_1.createFunction('rotate');
exports.rotate3d = formatting_1.createFunction('rotate3d');
exports.rotateX = formatting_1.createFunction('rotateX');
exports.rotateY = formatting_1.createFunction('rotateY');
exports.rotateZ = formatting_1.createFunction('rotateZ');
exports.scale = formatting_1.createFunction('scale');
exports.scale3d = formatting_1.createFunction('scale3d');
exports.scaleX = formatting_1.createFunction('scaleX');
exports.scaleY = formatting_1.createFunction('scaleY');
exports.scaleZ = formatting_1.createFunction('scaleZ');
exports.skew = formatting_1.createFunction('skew');
exports.skewX = formatting_1.createFunction('skewX');
exports.skewY = formatting_1.createFunction('skewY');
exports.translate = formatting_1.createFunction('translate');
exports.translate3d = formatting_1.createFunction('translate3d');
exports.translateX = formatting_1.createFunction('translateX');
exports.translateY = formatting_1.createFunction('translateY');
exports.translateZ = formatting_1.createFunction('translateZ');
