(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-core/dist/js/components/Button", "@patternfly/react-icons/dist/js/icons/pencil-alt-icon", "@patternfly/react-icons/dist/js/icons/check-icon", "@patternfly/react-icons/dist/js/icons/times-icon", "@patternfly/react-styles/css/components/InlineEdit/inline-edit", "classnames"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-core/dist/js/components/Button"), require("@patternfly/react-icons/dist/js/icons/pencil-alt-icon"), require("@patternfly/react-icons/dist/js/icons/check-icon"), require("@patternfly/react-icons/dist/js/icons/times-icon"), require("@patternfly/react-styles/css/components/InlineEdit/inline-edit"), require("classnames"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.Button, global.pencilAltIcon, global.checkIcon, global.timesIcon, global.inlineEdit, global.classnames);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _Button, _pencilAltIcon, _checkIcon, _timesIcon, _inlineEdit, _classnames) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.EditColumn = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _pencilAltIcon2 = _interopRequireDefault(_pencilAltIcon);

  var _checkIcon2 = _interopRequireDefault(_checkIcon);

  var _timesIcon2 = _interopRequireDefault(_timesIcon);

  var _inlineEdit2 = _interopRequireDefault(_inlineEdit);

  var _classnames2 = _interopRequireDefault(_classnames);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const EditColumn = exports.EditColumn = _ref => {
    let {
      onClick = null,

      /* eslint-disable @typescript-eslint/no-unused-vars */
      className = '',
      editing,
      valid,

      /* eslint-enable @typescript-eslint/no-unused-vars */
      saveAriaLabel,
      cancelAriaLabel,
      editAriaLabel
    } = _ref,
        props = _objectWithoutProperties(_ref, ["onClick", "className", "editing", "valid", "saveAriaLabel", "cancelAriaLabel", "editAriaLabel"]);

    return React.createElement(React.Fragment, null, React.createElement("div", {
      className: (0, _classnames2.default)(_inlineEdit2.default.inlineEditGroup, _inlineEdit2.default.modifiers.iconGroup, 'pf-m-action-group')
    }, React.createElement("div", {
      className: (0, _classnames2.default)(_inlineEdit2.default.inlineEditAction)
    }, React.createElement(_Button.Button, _extends({
      "aria-label": saveAriaLabel
    }, props, {
      onClick: e => onClick(e, 'save'),
      variant: "plain"
    }), React.createElement(_checkIcon2.default, null))), React.createElement("div", {
      className: (0, _classnames2.default)(_inlineEdit2.default.inlineEditAction)
    }, React.createElement(_Button.Button, _extends({
      "aria-label": cancelAriaLabel
    }, props, {
      onClick: e => onClick(e, 'cancel'),
      variant: "plain"
    }), React.createElement(_timesIcon2.default, null)))), React.createElement("div", {
      className: (0, _classnames2.default)(_inlineEdit2.default.inlineEditAction, _inlineEdit2.default.modifiers.enableEditable)
    }, React.createElement(_Button.Button, _extends({
      "aria-label": editAriaLabel
    }, props, {
      onClick: e => onClick(e, 'edit'),
      variant: "plain"
    }), React.createElement(_pencilAltIcon2.default, null))));
  };

  EditColumn.propTypes = {
    name: _propTypes2.default.string,
    className: _propTypes2.default.string,
    onClick: _propTypes2.default.any,
    editing: _propTypes2.default.bool,
    valid: _propTypes2.default.bool,
    saveAriaLabel: _propTypes2.default.string.isRequired,
    cancelAriaLabel: _propTypes2.default.string.isRequired,
    editAriaLabel: _propTypes2.default.string.isRequired
  };
});
//# sourceMappingURL=EditColumn.js.map