"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAnalysisResults = void 0;
const types_1 = require("../analyzer/types");
function parseAnalysisResults(targetImage, analysis) {
    let analysisResult = analysis.results.filter((res) => {
        return res.Analysis && res.Analysis.length > 0;
    })[0];
    if (!analysisResult) {
        // Special case when we have no package management
        // on scratch images or images with unknown package manager
        analysisResult = {
            Image: targetImage,
            AnalyzeType: types_1.AnalysisType.Linux,
            Analysis: [],
        };
    }
    let depType;
    switch (analysisResult.AnalyzeType) {
        case types_1.AnalysisType.Apt: {
            depType = "deb";
            break;
        }
        default: {
            depType = analysisResult.AnalyzeType.toLowerCase();
        }
    }
    return {
        imageId: analysis.imageId,
        platform: analysis.platform,
        targetOS: analysis.osRelease,
        type: depType,
        depInfosList: analysisResult.Analysis,
        imageLayers: analysis.imageLayers,
    };
}
exports.parseAnalysisResults = parseAnalysisResults;
//# sourceMappingURL=index.js.map