"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getYarnWorkspaces = exports.createDepTreeDepFromDep = exports.getTopLevelDeps = exports.parseManifestFile = exports.LockfileType = exports.Scope = void 0;
const errors_1 = require("../errors");
var Scope;
(function (Scope) {
    Scope["prod"] = "prod";
    Scope["dev"] = "dev";
})(Scope = exports.Scope || (exports.Scope = {}));
var LockfileType;
(function (LockfileType) {
    LockfileType["npm"] = "npm";
    LockfileType["npm7"] = "npm7";
    LockfileType["yarn"] = "yarn";
    LockfileType["yarn2"] = "yarn2";
})(LockfileType = exports.LockfileType || (exports.LockfileType = {}));
function parseManifestFile(manifestFileContents) {
    try {
        return JSON.parse(manifestFileContents);
    }
    catch (e) {
        throw new errors_1.InvalidUserInputError('package.json parsing failed with error ' + e.message);
    }
}
exports.parseManifestFile = parseManifestFile;
function getTopLevelDeps(targetFile, includeDev, lockfile) {
    const dependencies = [];
    const dependenciesIterator = Object.entries(Object.assign(Object.assign(Object.assign({}, targetFile.dependencies), (includeDev ? targetFile.devDependencies : null)), (targetFile.optionalDependencies || {})));
    for (const [name, version] of dependenciesIterator) {
        dependencies.push({
            dev: includeDev && targetFile.devDependencies
                ? !!targetFile.devDependencies[name]
                : false,
            name,
            version,
        });
    }
    // Only include peerDependencies if using npm and npm is at least
    // version 7 as npm v7 automatically installs peerDependencies
    if (lockfile.type === LockfileType.npm7 && targetFile.peerDependencies) {
        for (const [name, version] of Object.entries(targetFile.peerDependencies)) {
            dependencies.push({
                name,
                version,
            });
        }
    }
    return dependencies;
}
exports.getTopLevelDeps = getTopLevelDeps;
function createDepTreeDepFromDep(dep) {
    return {
        labels: {
            scope: dep.dev ? Scope.dev : Scope.prod,
        },
        name: dep.name,
        version: dep.version,
    };
}
exports.createDepTreeDepFromDep = createDepTreeDepFromDep;
function getYarnWorkspaces(targetFile) {
    try {
        const packageJson = parseManifestFile(targetFile);
        if (!!packageJson.workspaces && !!packageJson.private) {
            const workspacesPackages = packageJson.workspaces;
            const workspacesAlternateConfigPackages = packageJson.workspaces
                .packages;
            return [...(workspacesAlternateConfigPackages || workspacesPackages)];
        }
        return false;
    }
    catch (e) {
        throw new errors_1.InvalidUserInputError('package.json parsing failed with ' + `error ${e.message}`);
    }
}
exports.getYarnWorkspaces = getYarnWorkspaces;
//# sourceMappingURL=index.js.map