import * as React from "react";
import * as PropTypes from "prop-types";
export declare type Omit<O, K extends string> = Pick<O, Exclude<keyof O, K>>;
export declare type Overwrite<O1, O2> = Pick<O1, Exclude<keyof O1, keyof O2>> & O2;
type DivProps = Omit<React.HTMLProps<HTMLDivElement>, "ref">;
type FlexViewProps = {
    /** FlexView content */
    children?: React.ReactNode;
    /** flex-direction: column */
    column?: boolean;
    /** align content vertically */
    vAlignContent?: "top" | "center" | "bottom";
    /** align content horizontally */
    hAlignContent?: "left" | "center" | "right";
    /** margin-left property ("auto" to align self right) */
    marginLeft?: string | number;
    /** margin-top property ("auto" to align self bottom) */
    marginTop?: string | number;
    /** margin-right property ("auto" to align self left) */
    marginRight?: string | number;
    /** margin-bottom property ("auto" to align self top) */
    marginBottom?: string | number;
    /** grow property (for parent primary axis) */
    grow?: boolean | number;
    /** flex-shrink property */
    shrink?: boolean | number;
    /** flex-basis property */
    basis?: string | number;
    /** wrap content */
    wrap?: boolean;
    /** height property (for parent secondary axis) */
    height?: string | number;
    /** width property (for parent secondary axis) */
    width?: string | number;
    /** class to pass to top level element of the component */
    className?: string;
    /** style object to pass to top level element of the component */
    style?: React.CSSProperties;
};
export declare namespace FlexView {
    type Props = Overwrite<DivProps, FlexViewProps>;
}
/** A powerful React component to abstract over flexbox and create any layout on any browser */
export declare class FlexView extends React.Component<FlexView.Props> {
    static propTypes: {
        children: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        column: PropTypes.Requireable<boolean>;
        vAlignContent: PropTypes.Requireable<string>;
        hAlignContent: PropTypes.Requireable<string>;
        marginLeft: PropTypes.Requireable<string | number>;
        marginTop: PropTypes.Requireable<string | number>;
        marginRight: PropTypes.Requireable<string | number>;
        marginBottom: PropTypes.Requireable<string | number>;
        grow: PropTypes.Requireable<number | boolean>;
        shrink: PropTypes.Requireable<number | boolean>;
        basis: PropTypes.Requireable<string | number>;
        wrap: PropTypes.Requireable<boolean>;
        height: PropTypes.Requireable<string | number>;
        width: PropTypes.Requireable<string | number>;
        className: PropTypes.Requireable<string>;
        style: PropTypes.Requireable<object>;
    };
    componentDidMount(): void;
    logWarnings(): void;
    getGrow(): number;
    getShrink(): number;
    getBasis(): string;
    getStyle(): React.CSSProperties;
    getDivProps(): DivProps & {
        [k in keyof FlexViewProps]?: never;
    };
    render(): JSX.Element;
}
export default FlexView;
