"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLineLocationForYamlElement = exports.findLineNumberOfGivenPath = exports.removeInputPathPrefix = exports.getPathDetails = exports.buildTreeForTypeMap = void 0;
var types_1 = require("../types");
var parser_1 = require("./yaml/parser");
var parser_2 = require("./json/parser");
var parser_3 = require("./tf/parser");
exports.buildTreeForTypeMap = (_a = {},
    _a[types_1.CloudConfigFileTypes.YAML] = parser_1.buildYamlTreeMap,
    _a[types_1.CloudConfigFileTypes.JSON] = parser_2.buildJsonTreeMap,
    _a[types_1.CloudConfigFileTypes.TF] = parser_3.buildTfTreeMap,
    _a);
function getPathDetails(path, fileType) {
    if (fileType === types_1.CloudConfigFileTypes.YAML) {
        return parser_1.getPathDetailsForYamlFile(path);
    }
    return {
        docId: 0,
        path: removeInputPathPrefix(path),
    };
}
exports.getPathDetails = getPathDetails;
function removeInputPathPrefix(path) {
    if (path[0] === 'input') {
        return path.splice(1);
    }
    return path;
}
exports.removeInputPathPrefix = removeInputPathPrefix;
function findLineNumberOfGivenPath(nodes, pathDetails) {
    var filteredNodes = nodes.filter(function (node) { return node.key === pathDetails.path[0]; });
    if (filteredNodes.length === 0) {
        //Not exists
        return nodes[0].lineLocation.line;
    }
    if (pathDetails.path.length === 1) {
        return filteredNodes[0].lineLocation.line;
    }
    return getLineNumberForSingleNode(filteredNodes[0], pathDetails.path.splice(1));
}
exports.findLineNumberOfGivenPath = findLineNumberOfGivenPath;
function getLineNumberForSingleNode(baseNode, remainingPath) {
    var node = baseNode;
    while (remainingPath.length) {
        if (typeof node.values === 'string') {
            return node.lineLocation.line;
        }
        var nodeForPath = getNodeForPath(node.values, remainingPath[0]);
        if (!nodeForPath) {
            //Not exists
            return node.lineLocation.line;
        }
        node = nodeForPath;
        remainingPath = remainingPath.splice(1);
    }
    return node.lineLocation.line;
}
function getNodeForPath(nodeValues, path) {
    if (!path.includes('[')) {
        return nodeValues.find(function (currNode) {
            return currNode.key.startsWith(path + "[") || currNode.key === path;
        });
    }
    var _a = path.replace(']', '').split('['), nodeName = _a[0], subNodeName = _a[1];
    var subNodeId = parseInt(subNodeName);
    if (!isNaN(subNodeId) && Number.isInteger(subNodeId)) {
        return nodeValues.find(function (currNode) { return currNode.key === path; });
    }
    return nodeValues.find(function (currNode) {
        var values = currNode.values;
        if (typeof values !== 'string') {
            return (currNode.key === path ||
                (currNode.key.startsWith(nodeName) &&
                    values.filter(function (value) {
                        return value.key === 'name' && value.values === subNodeName;
                    }).length > 0));
        }
        return false;
    });
}
function getLineLocationForYamlElement(nodeElement) {
    return {
        line: nodeElement.startMark.line + 1,
        columnStart: nodeElement.startMark.pointer,
        columnEnd: nodeElement.endMark.pointer,
    };
}
exports.getLineLocationForYamlElement = getLineLocationForYamlElement;
//# sourceMappingURL=utils.js.map