/// <reference types="emscripten" />
export declare type Libzip = ReturnType<typeof makeInterface>;
export declare enum Errors {
    ZIP_ER_OK = 0,
    ZIP_ER_MULTIDISK = 1,
    ZIP_ER_RENAME = 2,
    ZIP_ER_CLOSE = 3,
    ZIP_ER_SEEK = 4,
    ZIP_ER_READ = 5,
    ZIP_ER_WRITE = 6,
    ZIP_ER_CRC = 7,
    ZIP_ER_ZIPCLOSED = 8,
    ZIP_ER_NOENT = 9,
    ZIP_ER_EXISTS = 10,
    ZIP_ER_OPEN = 11,
    ZIP_ER_TMPOPEN = 12,
    ZIP_ER_ZLIB = 13,
    ZIP_ER_MEMORY = 14,
    ZIP_ER_CHANGED = 15,
    ZIP_ER_COMPNOTSUPP = 16,
    ZIP_ER_EOF = 17,
    ZIP_ER_INVAL = 18,
    ZIP_ER_NOZIP = 19,
    ZIP_ER_INTERNAL = 20,
    ZIP_ER_INCONS = 21,
    ZIP_ER_REMOVE = 22,
    ZIP_ER_DELETED = 23,
    ZIP_ER_ENCRNOTSUPP = 24,
    ZIP_ER_RDONLY = 25,
    ZIP_ER_NOPASSWD = 26,
    ZIP_ER_WRONGPASSWD = 27,
    ZIP_ER_OPNOTSUPP = 28,
    ZIP_ER_INUSE = 29,
    ZIP_ER_TELL = 30,
    ZIP_ER_COMPRESSED_DATA = 31
}
export declare const makeInterface: (libzip: EmscriptenModule) => {
    readonly HEAP8: Int8Array;
    readonly HEAPU8: Uint8Array;
    readonly errors: typeof Errors;
    readonly SEEK_SET: 0;
    readonly SEEK_CUR: 1;
    readonly SEEK_END: 2;
    readonly ZIP_CHECKCONS: 4;
    readonly ZIP_CREATE: 1;
    readonly ZIP_EXCL: 2;
    readonly ZIP_TRUNCATE: 8;
    readonly ZIP_RDONLY: 16;
    readonly ZIP_FL_OVERWRITE: 8192;
    readonly ZIP_FL_COMPRESSED: 4;
    readonly ZIP_OPSYS_DOS: 0;
    readonly ZIP_OPSYS_AMIGA: 1;
    readonly ZIP_OPSYS_OPENVMS: 2;
    readonly ZIP_OPSYS_UNIX: 3;
    readonly ZIP_OPSYS_VM_CMS: 4;
    readonly ZIP_OPSYS_ATARI_ST: 5;
    readonly ZIP_OPSYS_OS_2: 6;
    readonly ZIP_OPSYS_MACINTOSH: 7;
    readonly ZIP_OPSYS_Z_SYSTEM: 8;
    readonly ZIP_OPSYS_CPM: 9;
    readonly ZIP_OPSYS_WINDOWS_NTFS: 10;
    readonly ZIP_OPSYS_MVS: 11;
    readonly ZIP_OPSYS_VSE: 12;
    readonly ZIP_OPSYS_ACORN_RISC: 13;
    readonly ZIP_OPSYS_VFAT: 14;
    readonly ZIP_OPSYS_ALTERNATE_MVS: 15;
    readonly ZIP_OPSYS_BEOS: 16;
    readonly ZIP_OPSYS_TANDEM: 17;
    readonly ZIP_OPSYS_OS_400: 18;
    readonly ZIP_OPSYS_OS_X: 19;
    readonly ZIP_CM_DEFAULT: -1;
    readonly ZIP_CM_STORE: 0;
    readonly ZIP_CM_DEFLATE: 8;
    readonly uint08S: number;
    readonly uint16S: number;
    readonly uint32S: number;
    readonly uint64S: number;
    readonly malloc: (size: number) => number;
    readonly free: (ptr: number) => void;
    readonly getValue: (ptr: number, type: string, noSafe?: boolean | undefined) => number;
    readonly open: (...args: any[]) => any;
    readonly openFromSource: (...args: any[]) => any;
    readonly close: (...args: any[]) => any;
    readonly discard: (...args: any[]) => any;
    readonly getError: (...args: any[]) => any;
    readonly getName: (...args: any[]) => any;
    readonly getNumEntries: (...args: any[]) => any;
    readonly delete: (...args: any[]) => any;
    readonly stat: (...args: any[]) => any;
    readonly statIndex: (...args: any[]) => any;
    readonly fopen: (...args: any[]) => any;
    readonly fopenIndex: (...args: any[]) => any;
    readonly fread: (...args: any[]) => any;
    readonly fclose: (...args: any[]) => any;
    readonly dir: {
        readonly add: (...args: any[]) => any;
    };
    readonly file: {
        readonly add: (...args: any[]) => any;
        readonly getError: (...args: any[]) => any;
        readonly getExternalAttributes: (...args: any[]) => any;
        readonly setExternalAttributes: (...args: any[]) => any;
        readonly setMtime: (...args: any[]) => any;
        readonly setCompression: (...args: any[]) => any;
    };
    readonly ext: {
        readonly countSymlinks: (...args: any[]) => any;
    };
    readonly error: {
        readonly initWithCode: (...args: any[]) => any;
        readonly strerror: (...args: any[]) => any;
    };
    readonly name: {
        readonly locate: (...args: any[]) => any;
    };
    readonly source: {
        readonly fromUnattachedBuffer: (...args: any[]) => any;
        readonly fromBuffer: (...args: any[]) => any;
        readonly free: (...args: any[]) => any;
        readonly keep: (...args: any[]) => any;
        readonly open: (...args: any[]) => any;
        readonly close: (...args: any[]) => any;
        readonly seek: (...args: any[]) => any;
        readonly tell: (...args: any[]) => any;
        readonly read: (...args: any[]) => any;
        readonly error: (...args: any[]) => any;
        readonly setMtime: (...args: any[]) => any;
    };
    readonly struct: {
        readonly stat: (...args: any[]) => any;
        readonly statS: (...args: any[]) => any;
        readonly statName: (...args: any[]) => any;
        readonly statIndex: (...args: any[]) => any;
        readonly statSize: (...args: any[]) => any;
        readonly statCompSize: (...args: any[]) => any;
        readonly statCompMethod: (...args: any[]) => any;
        readonly statMtime: (...args: any[]) => any;
        readonly error: (...args: any[]) => any;
        readonly errorS: (...args: any[]) => any;
        readonly errorCodeZip: (...args: any[]) => any;
    };
};
