"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPipenvInstalled = exports.extractPipenvVersion = void 0;
const debugLib = require("debug");
const sub_process_1 = require("./sub-process");
const debug = debugLib('snyk-fix:python:Pipfile');
function extractPipenvVersion(stdout) {
    /* stdout example:
     * pipenv, version 2018.11.26\n
     */
    let version = null;
    const re = new RegExp(/^pipenv,\sversion\s([0-9.]+)/, 'g');
    const match = re.exec(stdout);
    if (match) {
        version = match[1];
    }
    return version;
}
exports.extractPipenvVersion = extractPipenvVersion;
async function isPipenvInstalled() {
    let res;
    try {
        res = await sub_process_1.execute('pipenv', ['--version'], {});
    }
    catch (e) {
        debug('Execute failed with', e);
        res = e;
    }
    if (res.exitCode !== 0) {
        throw res.error;
    }
    return { version: extractPipenvVersion(res.stdout) };
}
exports.isPipenvInstalled = isPipenvInstalled;
//# sourceMappingURL=check-pip-env-installed.js.map