"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkWebpackVersion = void 0;

var _semver = _interopRequireDefault(require("@storybook/semver"));

var _nodeLogger = require("@storybook/node-logger");

var _tsDedent = _interopRequireDefault(require("ts-dedent"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var checkWebpackVersion = function (webpack, specifier, caption) {
  if (!webpack.version) {
    _nodeLogger.logger.info('Skipping webpack version check, no version available');

    return;
  }

  if (!_semver.default.satisfies(webpack.version, specifier)) {
    _nodeLogger.logger.warn((0, _tsDedent.default)`
      Unexpected webpack version in ${caption}
      - Received: ${webpack.version}
      - Expected: ${specifier}

      For more info: https://gist.github.com/shilman/8856ea1786dcd247139b47b270912324#troubleshooting
    `);
  }
};

exports.checkWebpackVersion = checkWebpackVersion;