"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFixCommandIsSupported = void 0;
const Debug = require("debug");
const ecosystems_1 = require("../../../lib/ecosystems");
const feature_flags_1 = require("../../../lib/feature-flags");
const command_not_supported_1 = require("../../../lib/errors/command-not-supported");
const not_supported_by_ecosystem_1 = require("../../../lib/errors/not-supported-by-ecosystem");
const errors_1 = require("../../../lib/errors");
const debug = Debug('snyk-fix');
const snykFixFeatureFlag = 'cliSnykFix';
async function validateFixCommandIsSupported(options) {
    if (options.docker) {
        throw new not_supported_by_ecosystem_1.FeatureNotSupportedByEcosystemError('snyk fix', 'docker');
    }
    const ecosystem = ecosystems_1.getEcosystemForTest(options);
    if (ecosystem) {
        throw new not_supported_by_ecosystem_1.FeatureNotSupportedByEcosystemError('snyk fix', ecosystem);
    }
    const snykFixSupported = await feature_flags_1.isFeatureFlagSupportedForOrg(snykFixFeatureFlag, options.org);
    debug('Feature flag check returned: ', snykFixSupported);
    if (snykFixSupported.code === 401 || snykFixSupported.code === 403) {
        throw errors_1.AuthFailedError(snykFixSupported.error, snykFixSupported.code);
    }
    if (!snykFixSupported.ok) {
        throw new command_not_supported_1.CommandNotSupportedError('snyk fix', options.org || undefined);
    }
    return true;
}
exports.validateFixCommandIsSupported = validateFixCommandIsSupported;
//# sourceMappingURL=validate-fix-command-is-supported.js.map