"use strict";
const fs = require("fs");
const path = require("path");
const strip_ansi_1 = require("strip-ansi");
const DEFAULT_HELP = 'snyk';
function readHelpFile(filename) {
    const file = fs.readFileSync(filename, 'utf8');
    if (typeof process.env.NO_COLOR !== 'undefined' || !process.stdout.isTTY) {
        return strip_ansi_1.default(file);
    }
    return file;
}
module.exports = async function help(item) {
    if (!item || item === true || typeof item !== 'string' || item === 'help') {
        item = DEFAULT_HELP;
    }
    // cleanse the filename to only contain letters
    // aka: /\W/g but figured this was easier to read
    item = item.replace(/[^a-z-]/gi, '');
    try {
        const filename = path.resolve(__dirname, '../../../help/commands-txt', item === DEFAULT_HELP ? DEFAULT_HELP + '.txt' : `snyk-${item}.txt`);
        return readHelpFile(filename);
    }
    catch (error) {
        const filename = path.resolve(__dirname, '../../../help/commands-txt', DEFAULT_HELP + '.txt');
        return readHelpFile(filename);
    }
};
//# sourceMappingURL=help.js.map