import { IacProjectType, IacProjectTypes } from '../../../../lib/iac/constants';
import { SEVERITY } from '../../../../lib/snyk-test/common';
import { AnnotatedIssue, IgnoreSettings, TestResult } from '../../../../lib/snyk-test/legacy';
import { IacFileInDirectory, Options, TestOptions } from '../../../../lib/types';
export interface IacFileData extends IacFileInDirectory {
    fileContent: string;
}
export declare const VALID_FILE_TYPES: string[];
export interface IacFileParsed extends IacFileData {
    jsonContent: Record<string, unknown> | TerraformScanInput;
    projectType: IacProjectType;
    engineType: EngineType;
    docId?: number;
}
export interface IacFileParseFailure extends IacFileData {
    jsonContent: null;
    engineType: null;
    failureReason: string;
    err: Error;
}
export declare type ScanningResults = {
    scannedFiles: Array<IacFileScanResult>;
    unscannedFiles: Array<IacFileParseFailure>;
};
export declare type ParsingResults = {
    parsedFiles: Array<IacFileParsed>;
    failedFiles: Array<IacFileParseFailure>;
};
export interface IacFileScanResult extends IacFileParsed {
    violatedPolicies: PolicyMetadata[];
}
export declare type FormattedResult = {
    result: {
        cloudConfigResults: Array<PolicyMetadata>;
        projectType: IacProjectTypes;
    };
    meta: TestMeta;
    filesystemPolicy: boolean;
    vulnerabilities: AnnotatedIssue[];
    dependencyCount: number;
    licensesPolicy: object | null;
    ignoreSettings: IgnoreSettings | null;
    targetFile: string;
    projectName: string;
    org: string;
    policy: string;
    isPrivate: boolean;
    targetFilePath: string;
    packageManager: IacProjectType;
};
export declare type IacCustomPolicies = Record<string, {
    severity?: string;
}>;
export interface IacOrgSettings {
    meta: TestMeta;
    customPolicies: IacCustomPolicies;
}
export interface TestMeta {
    isPrivate: boolean;
    isLicensesEnabled: boolean;
    org: string;
    ignoreSettings?: IgnoreSettings | null;
    projectId?: string;
    policy?: string;
}
export interface OpaWasmInstance {
    evaluate: (data: Record<string, any>) => {
        results: PolicyMetadata[];
    };
    setData: (data: Record<string, any>) => void;
}
export declare type SafeAnalyticsOutput = Omit<IacFileParsed | IacFileParseFailure, 'fileContent' | 'jsonContent' | 'engineType'>;
export declare enum EngineType {
    Kubernetes = 0,
    Terraform = 1,
    CloudFormation = 2,
    Custom = 3
}
export interface PolicyMetadata {
    id: string;
    publicId: string;
    type: string;
    subType: string;
    title: string;
    documentation?: string;
    description: string;
    severity: SEVERITY | 'none';
    msg: string;
    policyEngineType: 'opa';
    issue: string;
    impact: string;
    resolve: string;
    references: string[];
}
export declare type IaCTestFlags = Pick<Options & TestOptions, 'org' | 'insecure' | 'debug' | 'experimental' | 'detectionDepth' | 'severityThreshold' | 'json' | 'sarif'> & {
    'json-file-output'?: string;
    'sarif-file-output'?: string;
    v?: boolean;
    version?: boolean;
    h?: boolean;
    help?: 'help';
    q?: boolean;
    quiet?: boolean;
    legacy?: boolean;
    rules?: string;
} & TerraformPlanFlags;
interface TerraformPlanFlags {
    scan?: TerraformPlanScanMode;
}
export declare enum TerraformPlanScanMode {
    DeltaScan = "resource-changes",
    FullScan = "planned-values"
}
export declare type IaCTestOptions = IaCTestFlags & {
    /** @deprecated Only used by the legacy `iac test` flow remove once local exec path is GA */
    iacDirFiles?: Array<IacFileInDirectory>;
};
export interface TerraformPlanResource {
    address: string;
    mode: string;
    type: string;
    name: string;
    values: Record<string, unknown>;
    index: number;
}
export interface TerraformPlanResourceChange extends Omit<TerraformPlanResource, 'values'> {
    change: {
        actions: ResourceActions;
        before: Record<string, unknown> | null;
        after: Record<string, unknown> | null;
    };
}
export interface TerraformPlanJson {
    resource_changes: Array<TerraformPlanResourceChange>;
}
export interface TerraformScanInput {
    resource: Record<string, Record<string, unknown>>;
    data: Record<string, Record<string, unknown>>;
}
export declare type ResourceActions = ['no-op'] | ['create'] | ['read'] | ['update'] | ['delete', 'create'] | ['create', 'delete'] | ['delete'];
export declare const VALID_RESOURCE_ACTIONS_FOR_DELTA_SCAN: ResourceActions[];
export declare const VALID_RESOURCE_ACTIONS_FOR_FULL_SCAN: ResourceActions[];
export declare enum IaCErrorCodes {
    FailedToInitLocalCacheError = 1000,
    FailedToCleanLocalCacheError = 1001,
    FailedToDownloadRulesError = 1002,
    FailedToExtractCustomRulesError = 1003,
    NoFilesToScanError = 1010,
    FailedToLoadFileError = 1011,
    UnsupportedFileTypeError = 1020,
    InvalidJsonFileError = 1021,
    InvalidYamlFileError = 1022,
    FailedToDetectJsonConfigError = 1023,
    FailedToDetectYamlConfigError = 1024,
    MissingRequiredFieldsInKubernetesYamlError = 1031,
    FailedToParseHelmError = 1032,
    FailedToParseTerraformFileError = 1040,
    FailedToExtractResourcesInTerraformPlanError = 1052,
    FailedToBuildPolicyEngine = 1060,
    FailedToExecutePolicyEngine = 1061,
    FailedToFormatResults = 1070,
    FailedToExtractLineNumberError = 1071,
    FailedToGetIacOrgSettingsError = 1080,
    FlagError = 1090,
    FlagValueError = 1091
}
export interface TestReturnValue {
    results: TestResult | TestResult[];
    failures?: IacFileInDirectory[];
}
export {};
