"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandNotSupportedError = void 0;
const custom_error_1 = require("./custom-error");
class CommandNotSupportedError extends custom_error_1.CustomError {
    constructor(command, org) {
        super(`${command} is not supported for org ${org}.`);
        this.code = 422;
        this.command = command;
        this.org = org;
        this.userMessage = `\`${command}\` is not supported ${org ? `for org '${org}'` : ''}`;
    }
}
exports.CommandNotSupportedError = CommandNotSupportedError;
//# sourceMappingURL=command-not-supported.js.map