"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureNotSupportedByEcosystemError = void 0;
const custom_error_1 = require("./custom-error");
class FeatureNotSupportedByEcosystemError extends custom_error_1.CustomError {
    constructor(feature, ecosystem) {
        super(`Unsupported ecosystem ${ecosystem} for ${feature}.`);
        this.code = 422;
        this.feature = feature;
        this.userMessage = `\`${feature}\` is not supported for ecosystem '${ecosystem}'`;
    }
}
exports.FeatureNotSupportedByEcosystemError = FeatureNotSupportedByEcosystemError;
//# sourceMappingURL=not-supported-by-ecosystem.js.map