"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.codePlugin = void 0;
const chalk_1 = require("chalk");
const debugLib = require("debug");
const analysis_1 = require("./analysis");
const validate_1 = require("./validate");
const output_format_1 = require("./format/output-format");
const failed_to_run_test_error_1 = require("../../errors/failed-to-run-test-error");
const json_1 = require("../../json");
const analytics = require("../../analytics");
const debug = debugLib('snyk-code-test');
exports.codePlugin = {
    // We currently don't use scan/display. we will need to consolidate ecosystem plugins
    // to accept flows that act differently in the `testDependencies` step, as we have here
    async scan() {
        return null;
    },
    async display() {
        return '';
    },
    async test(paths, options) {
        var _a, _b;
        try {
            await validate_1.validateCodeTest(options);
            analytics.add('sast-scan', true);
            // Currently code supports only one path
            const path = paths[0];
            const sarifTypedResult = await analysis_1.getCodeAnalysisAndParseResults(path, options);
            const numOfIssues = ((_b = (_a = sarifTypedResult.runs) === null || _a === void 0 ? void 0 : _a[0].results) === null || _b === void 0 ? void 0 : _b.length) || 0;
            analytics.add('sast-issues-found', numOfIssues);
            if (options.sarif || options.json) {
                if (numOfIssues > 0) {
                    hasIssues(json_1.jsonStringifyLargeObject(sarifTypedResult));
                }
                return { readableResult: json_1.jsonStringifyLargeObject(sarifTypedResult) };
            }
            const meta = output_format_1.getMeta(options, path);
            const prefix = output_format_1.getPrefix(path);
            const readableResult = output_format_1.getCodeDisplayedOutput(sarifTypedResult, meta, prefix);
            if (numOfIssues > 0) {
                hasIssues(readableResult);
            }
            return { readableResult };
        }
        catch (error) {
            let err;
            if (isCodeClientError(error)) {
                const isUnauthorized = isUnauthorizedError(error)
                    ? 'Unauthorized: '
                    : '';
                err = new failed_to_run_test_error_1.FailedToRunTestError(`${isUnauthorized}Failed to run 'code test'`, error.statusCode);
            }
            else if (error instanceof Error) {
                err = error;
            }
            else if (isUnauthorizedError(error)) {
                err = new failed_to_run_test_error_1.FailedToRunTestError(error.message, error.code);
            }
            else {
                err = new Error(error);
            }
            debug(chalk_1.default.bold.red(error.statusText || error.message));
            throw err;
        }
    },
};
function isCodeClientError(error) {
    return (error.hasOwnProperty('statusCode') &&
        error.hasOwnProperty('statusText') &&
        error.hasOwnProperty('apiName'));
}
function isUnauthorizedError(error) {
    return ((error.statusCode >= 400 && error.statusCode < 500) ||
        (error.code >= 400 && error.code < 500));
}
function hasIssues(readableResult) {
    const err = new Error(readableResult);
    err.code = 'VULNS';
    throw err;
}
//# sourceMappingURL=index.js.map