"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getGradleAttributesPretty = void 0;
const chalk = require("chalk");
function getGradleAttributesPretty(output) {
    try {
        const lines = output.split('\n');
        if (lines === null) {
            return undefined;
        }
        let jsonLine = null;
        lines.forEach((l) => {
            const line = l.trim();
            // Extract attribute information via JSONATTRS marker:
            if (/^JSONATTRS /.test(line)) {
                if (jsonLine === null) {
                    jsonLine = line.substr(10);
                }
            }
        });
        const jsonAttrs = JSON.parse(jsonLine);
        const attrNameWidth = Math.max(...Object.keys(jsonAttrs).map((name) => name.length));
        const jsonAttrsPretty = Object.keys(jsonAttrs)
            .map((name) => chalk.whiteBright(leftPad(name, attrNameWidth)) +
            ': ' +
            chalk.gray(jsonAttrs[name].join(', ')))
            .join('\n');
        return jsonAttrsPretty;
    }
    catch (e) {
        return undefined;
    }
}
exports.getGradleAttributesPretty = getGradleAttributesPretty;
// <insert a npm left-pad joke here>
function leftPad(s, n) {
    return ' '.repeat(Math.max(n - s.length, 0)) + s;
}
//# sourceMappingURL=gradle-attributes-pretty.js.map