# Kiali Governance

This document defines governance policies for the Kiali project.

## Maintainers

Kiali Maintainers have write access to the Kiali GitHub repositories https://github.com/kiali.
They can merge their own patches or patches from others. The current maintainers can be found in https://github.com/orgs/kiali/teams/maintainers.

This privilege is granted with an expectation of responsibility: maintainers care about the Kiali project and want to help it grow and improve. Above the ability to contribute changes, a maintainer has demonstrated the ability to collaborate well with the team, assign appropriate code reviewers, contribute high-quality code, and be thorough and timely with fixes, tests and documentation.

A maintainer is a contributor to the Kiali project's success and a citizen helping the project succeed.

## Becoming a Maintainer

To become a maintainer you need to demonstrate the following:

  * commitment to the project
    * participate in discussions, contributions, code reviews for 3 months or more,
    * perform code reviews for 10 non-trivial pull requests,
    * contribute 10 non-trivial pull requests and have them merged into project branches,
  * ability to write high quality code,
  * ability to collaborate with the team,
  * understanding of team policies and processes,
  * understanding of the project's code base and coding style.

A new maintainer must be proposed by an existing maintainer by sending a message to the
[kiali-dev@googlegroups.com](https://groups.google.com/forum/#!forum/kiali-dev)
mailing list containing the following information:

  * nominee's first and last name,
  * nominee's email address and GitHub user name,
  * an explanation of why the nominee should be a maintainer,
  * a list of links to non-trivial pull requests (top 10) authored by the nominee.

Two other maintainers need to second the nomination. If no one objects in 5 working days (U.S.), the nomination is accepted.  If anyone objects or wants more information, the maintainers discuss and usually come to a consensus (within the 5 working days). If issues can't be resolved, there's a simple majority vote among current maintainers.

## Changes in Maintainership

Maintainers can be removed by a 2/3 majority vote by maintainers, or by resignation.

## GitHub Project Administration

Maintainers will be added to the GitHub @kiali/maintainers team, and made a GitHub maintainer of that team.
They will be given write permission to the Kiali GitHub repositories https://github.com/kiali.

## Changes in Governance

All changes in Governance require a 2/3 majority vote by maintainers.

## Other Changes

Unless specified above, all other changes to the project require a 2/3 majority vote by maintainers.
Additionally, any maintainer may request that any change require a 2/3 majority vote by maintainers.