"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.spawn = void 0;
const childProcess = require("child_process");
async function spawn(command, args, options) {
    return new Promise((resolve, reject) => {
        let stdout = '';
        let stderr = '';
        const process = childProcess.spawn(command, args, options);
        process.stdout.on('data', (data) => {
            stdout += data;
        });
        process.stderr.on('data', (data) => {
            stderr += data;
        });
        process.on('close', (code) => {
            resolve({ code, stdout, stderr });
        });
        process.on('error', (err) => {
            reject(err);
        });
    });
}
exports.spawn = spawn;
//# sourceMappingURL=child-process.js.map