"use strict";
exports.__esModule = true;
/**
 * @module Flexbox abstraction
 *
 * -webkit- is needed for mobile safari (iPhone / iPad)
 * -ms- is needed for IE
 */
var typestyle_1 = require("typestyle");
/**
 * If you have more than one child prefer horizontal,vertical
 */
exports.flexRoot = {
    display: [
        '-ms-flexbox',
        '-webkit-flex',
        'flex',
    ]
};
/**
 * A general grouping component that has no impact on the parent flexbox properties e.g.
 * <vertical>
 *    <pass>
 *       <content/>
 *    </pass>
 * </vertical>
 */
exports.pass = {
    display: 'inherit',
    '-ms-flex-direction': 'inherit',
    '-webkit-flex-direction': 'inherit',
    flexDirection: 'inherit',
    '-ms-flex-positive': 1,
    '-webkit-flex-grow': 1,
    flexGrow: 1
};
exports.inlineRoot = {
    display: [
        '-ms-inline-flexbox',
        '-webkit-inline-flex',
        'inline-flex'
    ]
};
exports.horizontal = typestyle_1.extend(exports.flexRoot, {
    '-ms-flex-direction': 'row',
    '-webkit-flex-direction': 'row',
    flexDirection: 'row'
});
exports.vertical = typestyle_1.extend(exports.flexRoot, {
    '-ms-flex-direction': 'column',
    '-webkit-flex-direction': 'column',
    flexDirection: 'column'
});
exports.wrap = {
    '-ms-flex-wrap': 'wrap',
    '-webkit-flex-wrap': 'wrap',
    flexWrap: 'wrap'
};
/**
 * If you want items to be sized automatically by their children use this
 * This is because of a bug in various flexbox implementations: http://philipwalton.com/articles/normalizing-cross-browser-flexbox-bugs/
 * Specifically bug 1 : https://github.com/philipwalton/flexbugs#1-minimum-content-sizing-of-flex-items-not-honored
 */
exports.content = {
    '-ms-flex-negative': 0,
    '-webkit-flex-shrink': 0,
    flexShrink: 0,
    flexBasis: 'auto'
};
exports.flex = {
    '-ms-flex': 1,
    '-webkit-flex': 1,
    flex: 1
};
exports.flex1 = exports.flex;
exports.flex2 = {
    '-ms-flex': 2,
    '-webkit-flex': 2,
    flex: 2
};
exports.flex3 = {
    '-ms-flex': 3,
    '-webkit-flex': 3,
    flex: 3
};
exports.flex4 = {
    '-ms-flex': 4,
    '-webkit-flex': 4,
    flex: 4
};
exports.flex5 = {
    '-ms-flex': 5,
    '-webkit-flex': 5,
    flex: 5
};
exports.flex6 = {
    '-ms-flex': 6,
    '-webkit-flex': 6,
    flex: 6
};
exports.flex7 = {
    '-ms-flex': 7,
    '-webkit-flex': 7,
    flex: 7
};
exports.flex8 = {
    '-ms-flex': 8,
    '-webkit-flex': 8,
    flex: 8
};
exports.flex9 = {
    '-ms-flex': 9,
    '-webkit-flex': 9,
    flex: 9
};
exports.flex10 = {
    '-ms-flex': 10,
    '-webkit-flex': 10,
    flex: 10
};
exports.flex11 = {
    '-ms-flex': 11,
    '-webkit-flex': 11,
    flex: 11
};
exports.flex12 = {
    '-ms-flex': 12,
    '-webkit-flex': 12,
    flex: 12
};
/////////////////////////////
// Alignment in cross axis //
/////////////////////////////
exports.start = {
    '-ms-flex-align': 'start',
    '-webkit-align-items': 'flex-start',
    alignItems: 'flex-start'
};
exports.center = {
    '-ms-flex-align': 'center',
    '-webkit-align-items': 'center',
    alignItems: 'center'
};
exports.end = {
    '-ms-flex-align': 'end',
    '-webkit-align-items': 'flex-end',
    alignItems: 'flex-end'
};
////////////////////////////
// Alignment in main axis //
////////////////////////////
exports.startJustified = {
    '-ms-flex-pack': 'start',
    '-webkit-justify-content': 'flex-start',
    justifyContent: 'flex-start'
};
exports.centerJustified = {
    '-ms-flex-pack': 'center',
    '-webkit-justify-content': 'center',
    justifyContent: 'center'
};
exports.endJustified = {
    '-ms-flex-pack': 'end',
    '-webkit-justify-content': 'flex-end',
    justifyContent: 'flex-end'
};
exports.aroundJustified = {
    '-ms-flex-pack': 'distribute',
    '-webkit-justify-content': 'space-around',
    justifyContent: 'space-around'
};
exports.betweenJustified = {
    '-ms-flex-pack': 'justify',
    '-webkit-justify-content': 'space-between',
    justifyContent: 'space-between'
};
////////////////////////////
// Alignment in both axes //
////////////////////////////
exports.centerCenter = typestyle_1.extend(exports.flexRoot, exports.center, exports.centerJustified);
////////////////////
// Self alignment //
////////////////////
exports.selfStart = {
    '-ms-flex-item-align': 'start',
    '-webkit-align-self': 'flex-start',
    alignSelf: 'flex-start'
};
exports.selfCenter = {
    '-ms-flex-item-align': 'center',
    '-webkit-align-self': 'center',
    alignSelf: 'center'
};
exports.selfEnd = {
    '-ms-flex-item-align': 'end',
    '-webkit-align-self': 'flex-end',
    alignSelf: 'flex-end'
};
exports.selfStretch = {
    '-ms-flex-item-align': 'stretch',
    '-webkit-align-self': 'stretch',
    alignSelf: 'stretch'
};
