"use strict";
exports.__esModule = true;
var typestyle_1 = require("typestyle");
var box_1 = require("./box");
/**
 * Recommended Page setup
 * - Sets up the body to be full size
 * - Sets up box sizing to be border box
 **/
function setupPage(rootSelector) {
    /** Use full window size for application */
    typestyle_1.cssRule('html, body', {
        height: '100%',
        width: '100%',
        padding: 0,
        margin: 0
    });
    /** Use border box */
    typestyle_1.cssRule('html', {
        '-moz-box-sizing': 'border-box',
        '-webkit-box-sizing': 'border-box',
        boxSizing: 'border-box'
    });
    typestyle_1.cssRule('*,*:before,*:after', {
        boxSizing: 'inherit'
    });
    /** Also root should fill parent */
    typestyle_1.cssRule(rootSelector, box_1.fillParent);
}
exports.setupPage = setupPage;
