"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatUnresolved = void 0;
const chalk = require("chalk");
const format_display_name_1 = require("./format-display-name");
const show_results_summary_1 = require("./show-results-summary");
function formatUnresolved(entity, userMessage, tip) {
    const name = format_display_name_1.formatDisplayName(entity.workspace.path, entity.scanResult.identity);
    const tipMessage = tip ? `\n${show_results_summary_1.PADDING_SPACE}Tip:     ${tip}` : '';
    const errorMessage = `${show_results_summary_1.PADDING_SPACE}${name}\n${show_results_summary_1.PADDING_SPACE}${chalk.red('✖')} ${chalk.red(userMessage)}`;
    return errorMessage + tipMessage;
}
exports.formatUnresolved = formatUnresolved;
//# sourceMappingURL=format-unresolved-item.js.map