"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadPlugin = void 0;
const unsupported_type_error_1 = require("../lib/errors/unsupported-type-error");
const python_1 = require("./python");
function loadPlugin(type) {
    switch (type) {
        case 'pip': {
            return python_1.pythonFix;
        }
        default: {
            throw new unsupported_type_error_1.UnsupportedTypeError(type);
        }
    }
}
exports.loadPlugin = loadPlugin;
//# sourceMappingURL=load-plugin.js.map