import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { css, getModifier } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer';
export const NotificationDrawerListItem = (_ref) => {
  let {
    children,
    className = '',
    isHoverable = true,
    isRead = false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick = event => undefined,
    tabIndex = 0,
    variant = 'default'
  } = _ref,
      props = _objectWithoutProperties(_ref, ["children", "className", "isHoverable", "isRead", "onClick", "tabIndex", "variant"]);

  return React.createElement("li", _extends({}, props, {
    className: css(styles.notificationDrawerListItem, isHoverable && styles.modifiers.hoverable, getModifier(styles.modifiers, variant), isRead && styles.modifiers.read, className),
    tabIndex: tabIndex,
    onClick: e => onClick(e)
  }), children);
};
NotificationDrawerListItem.propTypes = {
  children: _pt.node,
  className: _pt.string,
  isHoverable: _pt.bool,
  isRead: _pt.bool,
  onClick: _pt.func,
  tabIndex: _pt.number,
  variant: _pt.oneOf(['success', 'danger', 'warning', 'info', 'default'])
};
//# sourceMappingURL=NotificationDrawerListItem.js.map