"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pipenvInstall = void 0;
const debugLib = require("debug");
const bottleneck_1 = require("bottleneck");
const sub_process_1 = require("./sub-process");
const debug = debugLib('snyk-fix:python:Pipfile');
const limiter = new bottleneck_1.default({
    maxConcurrent: 4,
});
// https://pipenv.pypa.io/en/latest/advanced/#changing-default-python-versions
function getPythonArgs(config) {
    const args = [];
    if (config.python) {
        args.push('--python', config.python); // Performs the installation in a virtualenv using the provided Python interpreter.
    }
    if (process.env.PIPENV_SKIP_LOCK) {
        args.push('--skip-lock');
    }
    return args;
}
async function runPipenvInstall(projectPath, requirements, config) {
    const args = ['install', ...requirements];
    const pythonArg = getPythonArgs(config);
    if (pythonArg) {
        args.push(...pythonArg);
    }
    let res;
    try {
        res = await sub_process_1.execute('pipenv', args, {
            cwd: projectPath,
        });
    }
    catch (e) {
        debug('Execute failed with', e);
        res = e;
    }
    return res;
}
exports.pipenvInstall = limiter.wrap(runPipenvInstall);
//# sourceMappingURL=pipenv-install.js.map