"use strict";
exports.__esModule = true;
function boxUnitToString(value) {
    if (typeof value === 'number') {
        return value.toString() + 'px';
    }
    else {
        return value;
    }
}
/**
 * Takes a function that expects Box to be passed into it
 * and creates a BoxFunction
 */
function createBoxFunction(mapFromBox) {
    var result = function (a, b, c, d) {
        if (b === undefined && c === undefined && d === undefined) {
            b = c = d = a;
        }
        else if (c === undefined && d === undefined) {
            c = a;
            d = b;
        }
        var box = {
            top: boxUnitToString(a),
            right: boxUnitToString(b),
            bottom: boxUnitToString(c),
            left: boxUnitToString(d)
        };
        return mapFromBox(box);
    };
    return result;
}
exports.padding = createBoxFunction(function (box) {
    return {
        paddingTop: box.top,
        paddingRight: box.right,
        paddingBottom: box.bottom,
        paddingLeft: box.left
    };
});
exports.margin = createBoxFunction(function (box) {
    return {
        marginTop: box.top,
        marginRight: box.right,
        marginBottom: box.bottom,
        marginLeft: box.left
    };
});
exports.border = createBoxFunction(function (box) {
    return {
        borderTop: box.top,
        borderRight: box.right,
        borderBottom: box.bottom,
        borderLeft: box.left
    };
});
/**
 * Puts a vertical margin between each child
 */
exports.verticallySpaced = function (margin) {
    var spacing = boxUnitToString(margin);
    return {
        '&>*': {
            marginBottom: spacing + ' !important'
        },
        '&>*:last-child': {
            marginBottom: '0px !important'
        }
    };
};
/**
 * Puts a horizontal margin between each child
 */
exports.horizontallySpaced = function (margin) {
    var spacing = boxUnitToString(margin);
    return {
        '&>*': {
            marginRight: spacing + ' !important'
        },
        '&>*:last-child': {
            marginRight: '0px !important'
        }
    };
};
/**
 * Puts a (horizontal AND vertical) margin between each child
 */
exports.gridSpaced = function (margin) {
    var spacing = boxUnitToString(margin);
    return {
        marginTop: '-' + spacing,
        marginLeft: '-' + spacing,
        '&>*': {
            marginTop: spacing,
            marginLeft: spacing
        }
    };
};
/**
 * Gives this element the same size as the nearest offsetParent
 */
exports.fillParent = {
    width: '100%',
    height: '100%'
};
/** mixin: maxWidth */
exports.maxWidth = function (value) {
    var maxWidth = boxUnitToString(value);
    return { maxWidth: maxWidth };
};
/** mixin: maxHeight */
exports.maxHeight = function (value) {
    var maxHeight = boxUnitToString(value);
    return { maxHeight: maxHeight };
};
/**
 * Block elements: Centering *self* using margins
 */
exports.horizontallyCenterSelf = {
    marginLeft: 'auto',
    marginRight: 'auto'
};
/**
 * Block elements: Centering *child* elements using textAlign
 */
exports.horizontallyCenterChildren = {
    textAlign: 'center'
};
/** mixin: height */
exports.height = function (value) {
    var height = boxUnitToString(value);
    return { height: height };
};
/** mixin: width */
exports.width = function (value) {
    var width = boxUnitToString(value);
    return { width: width };
};
