"use strict";

require("core-js/modules/es.promise.js");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managerWebpack = managerWebpack;
exports.managerEntries = managerEntries;

var _coreCommon = require("@storybook/core-common");

var _managerWebpack = _interopRequireDefault(require("../manager/manager-webpack.config"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

async function managerWebpack(_, options) {
  return (0, _managerWebpack.default)(options);
}

async function managerEntries(installedAddons, options) {
  var _options$managerEntry = options.managerEntry,
      managerEntry = _options$managerEntry === void 0 ? '@storybook/core-client/dist/esm/manager' : _options$managerEntry;
  var entries = [require.resolve('../globals/polyfills')];

  if (installedAddons && installedAddons.length) {
    entries.push(...installedAddons);
  }

  var managerConfig = (0, _coreCommon.loadManagerOrAddonsFile)(options);

  if (managerConfig) {
    entries.push(managerConfig);
  }

  entries.push(require.resolve(managerEntry));
  return entries;
}